package com.unity3d.ads.core.data.datasource

import com.unity3d.services.core.misc.JsonStorage

class AndroidMediationDataSource(private val publicStorage: JsonStorage) : MediationDataSource {
    override val name: String?
        get() = publicStorage.get(MEDIATION_NAME_KEY) as String?

    override val version: String?
        get() = publicStorage.get(MEDIATION_VERSION_KEY) as String?

    companion object {
        private const val MEDIATION_STORAGE_NAME = "mediation"
        private const val MEDIATION_NAME = "name"
        private const val MEDIATION_VERSION = "version"
        private const val MEDIATION_VALUE = "value"
        const val MEDIATION_NAME_KEY = "$MEDIATION_STORAGE_NAME.$MEDIATION_NAME.$MEDIATION_VALUE"
        const val MEDIATION_VERSION_KEY = "$MEDIATION_STORAGE_NAME.$MEDIATION_VERSION.$MEDIATION_VALUE"
    }
}