/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services;

import com.unity3d.ads.core.configuration.AlternativeFlowReader;
import com.unity3d.ads.core.domain.SendDiagnosticEvent;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/unity3d/services/SDKErrorHandler;", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "alternativeFlowReader", "Lcom/unity3d/ads/core/configuration/AlternativeFlowReader;", "sendDiagnosticEvent", "Lcom/unity3d/ads/core/domain/SendDiagnosticEvent;", "sdkMetricsSender", "Lcom/unity3d/services/core/request/metrics/SDKMetricsSender;", "(Lkotlinx/coroutines/CoroutineDispatcher;Lcom/unity3d/ads/core/configuration/AlternativeFlowReader;Lcom/unity3d/ads/core/domain/SendDiagnosticEvent;Lcom/unity3d/services/core/request/metrics/SDKMetricsSender;)V", "key", "Lkotlinx/coroutines/CoroutineExceptionHandler$Key;", "getKey", "()Lkotlinx/coroutines/CoroutineExceptionHandler$Key;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "handleException", "", "context", "Lkotlin/coroutines/CoroutineContext;", "exception", "", "sendDiagnostic", "name", "", "value", "sendMetric", "metric", "Lcom/unity3d/services/core/request/metrics/Metric;", "unity-ads_release"})
public final class SDKErrorHandler
implements CoroutineExceptionHandler {
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @NotNull
    private final AlternativeFlowReader alternativeFlowReader;
    @NotNull
    private final SendDiagnosticEvent sendDiagnosticEvent;
    @NotNull
    private final SDKMetricsSender sdkMetricsSender;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CoroutineExceptionHandler.Key key;

    public SDKErrorHandler(@NotNull CoroutineDispatcher ioDispatcher, @NotNull AlternativeFlowReader alternativeFlowReader, @NotNull SendDiagnosticEvent sendDiagnosticEvent, @NotNull SDKMetricsSender sdkMetricsSender) {
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        Intrinsics.checkNotNullParameter((Object)alternativeFlowReader, (String)"alternativeFlowReader");
        Intrinsics.checkNotNullParameter((Object)sendDiagnosticEvent, (String)"sendDiagnosticEvent");
        Intrinsics.checkNotNullParameter((Object)sdkMetricsSender, (String)"sdkMetricsSender");
        this.ioDispatcher = ioDispatcher;
        this.alternativeFlowReader = alternativeFlowReader;
        this.sendDiagnosticEvent = sendDiagnosticEvent;
        this.sdkMetricsSender = sdkMetricsSender;
        this.scope = CoroutineScopeKt.plus((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.ioDispatcher)), (CoroutineContext)((CoroutineContext)new CoroutineName("SDKErrorHandler")));
        this.key = CoroutineExceptionHandler.Key;
    }

    @NotNull
    public CoroutineExceptionHandler.Key getKey() {
        return this.key;
    }

    public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        StackTraceElement stackTraceElement = exception.getStackTrace()[0];
        String string = stackTraceElement != null ? stackTraceElement.getFileName() : null;
        if (string == null) {
            string = "unknown";
        }
        String className = string;
        StackTraceElement stackTraceElement2 = exception.getStackTrace()[0];
        int line = stackTraceElement2 != null ? stackTraceElement2.getLineNumber() : 0;
        Throwable throwable = exception;
        String name = throwable instanceof NullPointerException ? "native_exception_npe" : (throwable instanceof OutOfMemoryError ? "native_exception_oom" : (throwable instanceof IllegalStateException ? "native_exception_ise" : (throwable instanceof SecurityException ? "native_exception_se" : (throwable instanceof RuntimeException ? "native_exception_re" : "native_exception"))));
        boolean isAlternativeFlowEnabled = this.alternativeFlowReader.invoke();
        String crashValue = className + '_' + line;
        DeviceLog.error("Unity Ads SDK encountered an exception: " + crashValue);
        if (isAlternativeFlowEnabled) {
            this.sendDiagnostic(name, crashValue);
        } else {
            this.sendMetric(new Metric(name, crashValue, null, 4, null));
        }
    }

    private final void sendDiagnostic(String name, String value) {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, name, value, null){
            int label;
            final /* synthetic */ SDKErrorHandler this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SendDiagnosticEvent.DefaultImpls.invoke$default(SDKErrorHandler.access$getSendDiagnosticEvent$p(this.this$0), this.$name, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"reason", (Object)this.$value)), null, (Continuation)this, 10, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void sendMetric(Metric metric) {
        this.sdkMetricsSender.sendMetric(metric);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)CoroutineExceptionHandler.DefaultImpls.fold((CoroutineExceptionHandler)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        return (E)CoroutineExceptionHandler.DefaultImpls.get((CoroutineExceptionHandler)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        return CoroutineExceptionHandler.DefaultImpls.minusKey((CoroutineExceptionHandler)this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return CoroutineExceptionHandler.DefaultImpls.plus((CoroutineExceptionHandler)this, (CoroutineContext)context);
    }

    public static final /* synthetic */ SendDiagnosticEvent access$getSendDiagnosticEvent$p(SDKErrorHandler $this) {
        return $this.sendDiagnosticEvent;
    }
}

