/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.data.datasource;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import androidx.annotation.RequiresApi;
import com.unity3d.ads.core.data.datasource.AndroidDynamicDeviceInfoDataSource;
import com.unity3d.ads.core.data.datasource.DynamicDeviceInfoDataSource;
import com.unity3d.ads.core.data.datasource.VolumeSettingsChange;
import com.unity3d.services.core.device.AdvertisingId;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.OpenAdvertisingId;
import com.unity3d.services.core.lifecycle.LifecycleCache;
import com.unity3d.services.core.log.DeviceLog;
import gateway.v1.DynamicDeviceInfoKt;
import gateway.v1.DynamicDeviceInfoOuterClass;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 N2\u00020\u0001:\u0001NB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\rH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\fH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0006\u0010&\u001a\u00020$J\u0012\u0010'\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010)H\u0003J\b\u0010*\u001a\u00020\fH\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0002J\u0012\u0010.\u001a\u00020$2\b\u0010/\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u00100\u001a\u00020\fJ\b\u00101\u001a\u00020\rH\u0002J\b\u00102\u001a\u00020\fH\u0002J\b\u00103\u001a\u00020\fH\u0002J\b\u00104\u001a\u00020\u001dH\u0003J\b\u00105\u001a\u00020\fH\u0016J\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bJ\b\u00107\u001a\u00020\u001dH\u0016J\u0006\u00108\u001a\u00020\u001dJ\u000e\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001dJ\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001dH\u0002J\n\u0010<\u001a\u0004\u0018\u00010=H\u0002J\b\u0010>\u001a\u00020\fH\u0002J\b\u0010?\u001a\u00020$H\u0002J\u0006\u0010@\u001a\u00020$J\b\u0010A\u001a\u00020$H\u0002J\u0012\u0010B\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\b\u0010C\u001a\u00020\rH\u0016J\b\u0010D\u001a\u00020\rH\u0002J\b\u0010E\u001a\u00020\rH\u0003J\b\u0010F\u001a\u00020\rH\u0002J\b\u0010G\u001a\u00020\rH\u0002J\b\u0010H\u001a\u00020\rH\u0002J\b\u0010I\u001a\u00020\rH\u0002J\b\u0010J\u001a\u00020\rH\u0002J\b\u0010K\u001a\u00020\rH\u0002J\b\u0010L\u001a\u00020\rH\u0002J\b\u0010M\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006O"}, d2={"Lcom/unity3d/ads/core/data/datasource/AndroidDynamicDeviceInfoDataSource;", "Lcom/unity3d/ads/core/data/datasource/DynamicDeviceInfoDataSource;", "context", "Landroid/content/Context;", "lifecycleCache", "Lcom/unity3d/services/core/lifecycle/LifecycleCache;", "(Landroid/content/Context;Lcom/unity3d/services/core/lifecycle/LifecycleCache;)V", "getContext", "()Landroid/content/Context;", "reportedWarning", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "", "", "volumeSettingsChange", "Lkotlinx/coroutines/flow/Flow;", "Lcom/unity3d/ads/core/data/datasource/VolumeSettingsChange;", "getVolumeSettingsChange", "()Lkotlinx/coroutines/flow/Flow;", "adbStatus", "fetch", "Lgateway/v1/DynamicDeviceInfoOuterClass$DynamicDeviceInfo;", "fetchAndroidDynamicDeviceInfo", "Lgateway/v1/DynamicDeviceInfoOuterClass$DynamicDeviceInfo$Android;", "getAudioManager", "Landroid/media/AudioManager;", "getBatteryLevel", "", "getBatteryStatus", "", "getConnectionType", "Lgateway/v1/DynamicDeviceInfoOuterClass$ConnectionType;", "getConnectionTypeStr", "getConnectivityManager", "Landroid/net/ConnectivityManager;", "getElapsedRealtime", "", "getEventTimeStamp", "getFreeMemory", "getFreeSpace", "file", "Ljava/io/File;", "getLanguage", "getMemoryInfo", "infoType", "Lcom/unity3d/services/core/device/Device$MemoryInfoType;", "getMemoryValueFromString", "memVal", "getNetworkCountryISO", "getNetworkMetered", "getNetworkOperator", "getNetworkOperatorName", "getNetworkType", "getOrientation", "getProcessInfo", "getRingerMode", "getScreenBrightness", "getStreamMaxVolume", "streamType", "getStreamVolume", "getTelephonyManager", "Landroid/telephony/TelephonyManager;", "getTimeZone", "getTimeZoneOffset", "getTotalMemory", "getUptime", "getUsableSpace", "hasInternet", "hasInternetConnection", "hasInternetConnectionM", "isActiveNetworkConnected", "isAdbEnabled", "isAppActive", "isLimitAdTrackingEnabled", "isLimitOpenAdTrackingEnabled", "isUSBConnected", "isUsingWifi", "isWiredHeadsetOn", "Companion", "unity-ads_release"})
@SourceDebugExtension(value={"SMAP\nAndroidDynamicDeviceInfoDataSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidDynamicDeviceInfoDataSource.kt\ncom/unity3d/ads/core/data/datasource/AndroidDynamicDeviceInfoDataSource\n+ 2 DynamicDeviceInfoKt.kt\ngateway/v1/DynamicDeviceInfoKtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DynamicDeviceInfoKt.kt\ngateway/v1/DynamicDeviceInfoKt\n*L\n1#1,649:1\n8#2:650\n1#3:651\n1#3:653\n610#4:652\n*S KotlinDebug\n*F\n+ 1 AndroidDynamicDeviceInfoDataSource.kt\ncom/unity3d/ads/core/data/datasource/AndroidDynamicDeviceInfoDataSource\n*L\n57#1:650\n57#1:651\n75#1:653\n75#1:652\n*E\n"})
public final class AndroidDynamicDeviceInfoDataSource
implements DynamicDeviceInfoDataSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final LifecycleCache lifecycleCache;
    @NotNull
    private final MutableStateFlow<Map<String, Boolean>> reportedWarning;
    @NotNull
    private final Flow<VolumeSettingsChange> volumeSettingsChange;
    @NotNull
    public static final String DIRECTORY_MEM_INFO = "/proc/meminfo";
    @NotNull
    public static final String DIRECTORY_PROCESS_INFO = "/proc/self/stat";
    @NotNull
    public static final String DIRECTORY_MODE_READ = "r";
    @NotNull
    public static final String KEY_STAT_CONTENT = "stat";
    @NotNull
    public static final String INTENT_USB_STATE = "android.hardware.usb.action.USB_STATE";
    @NotNull
    public static final String USB_EXTRA_CONNECTED = "connected";

    public AndroidDynamicDeviceInfoDataSource(@NotNull Context context, @NotNull LifecycleCache lifecycleCache) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lifecycleCache, (String)"lifecycleCache");
        this.context = context;
        this.lifecycleCache = lifecycleCache;
        this.reportedWarning = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this.volumeSettingsChange = FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super VolumeSettingsChange>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AndroidDynamicDeviceInfoDataSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        Ref.DoubleRef currentVolume = new Ref.DoubleRef();
                        currentVolume.element = AndroidDynamicDeviceInfoDataSource.access$getStreamVolume(this.this$0, 3);
                        ChannelsKt.trySendBlocking((SendChannel)((SendChannel)$this$callbackFlow), (Object)new VolumeSettingsChange.VolumeChange(currentVolume.element));
                        Ref.IntRef currentRingerMode = new Ref.IntRef();
                        currentRingerMode.element = this.this$0.getRingerMode();
                        ChannelsKt.trySendBlocking((SendChannel)((SendChannel)$this$callbackFlow), (Object)new VolumeSettingsChange.MuteChange(currentRingerMode.element == 0));
                        ContentObserver contentObserver2 = new ContentObserver(this.this$0, currentVolume, (ProducerScope<? super VolumeSettingsChange>)$this$callbackFlow, currentRingerMode){
                            final /* synthetic */ AndroidDynamicDeviceInfoDataSource this$0;
                            final /* synthetic */ Ref.DoubleRef $currentVolume;
                            final /* synthetic */ ProducerScope<VolumeSettingsChange> $$this$callbackFlow;
                            final /* synthetic */ Ref.IntRef $currentRingerMode;
                            {
                                this.this$0 = $receiver;
                                this.$currentVolume = $currentVolume;
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                this.$currentRingerMode = $currentRingerMode;
                                super(null);
                            }

                            public void onChange(boolean selfChange) {
                                int newRingerMode;
                                super.onChange(selfChange);
                                double newVolume = AndroidDynamicDeviceInfoDataSource.access$getStreamVolume(this.this$0, 3);
                                if (!(newVolume == this.$currentVolume.element)) {
                                    this.$currentVolume.element = newVolume;
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)new VolumeSettingsChange.VolumeChange(newVolume));
                                }
                                if ((newRingerMode = this.this$0.getRingerMode()) != this.$currentRingerMode.element) {
                                    this.$currentRingerMode.element = newRingerMode;
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.$$this$callbackFlow), (Object)new VolumeSettingsChange.MuteChange(newRingerMode == 0));
                                }
                            }
                        };
                        this.this$0.getContext().getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, contentObserver2);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(this.this$0, contentObserver2){
                            final /* synthetic */ AndroidDynamicDeviceInfoDataSource this$0;
                            final /* synthetic */ volumeSettingsChange.contentObserver.1 $contentObserver;
                            {
                                this.this$0 = $receiver;
                                this.$contentObserver = $contentObserver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getContext().getContentResolver().unregisterContentObserver((ContentObserver)this.$contentObserver);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super VolumeSettingsChange>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super VolumeSettingsChange> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public DynamicDeviceInfoOuterClass.DynamicDeviceInfo fetch() {
        DynamicDeviceInfoKt.Dsl dsl;
        boolean bl = false;
        DynamicDeviceInfoOuterClass.DynamicDeviceInfo.Builder builder = DynamicDeviceInfoOuterClass.DynamicDeviceInfo.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        DynamicDeviceInfoKt.Dsl $this$dynamicDeviceInfo_u24lambda_u240$iv = dsl = DynamicDeviceInfoKt.Dsl.Companion._create(builder);
        boolean bl2 = false;
        DynamicDeviceInfoKt.Dsl $this$fetch_u24lambda_u240 = $this$dynamicDeviceInfo_u24lambda_u240$iv;
        boolean bl3 = false;
        $this$fetch_u24lambda_u240.setLanguage(this.getLanguage());
        $this$fetch_u24lambda_u240.setNetworkOperator(this.getNetworkOperator());
        $this$fetch_u24lambda_u240.setNetworkOperatorName(this.getNetworkOperatorName());
        $this$fetch_u24lambda_u240.setFreeDiskSpace(this.getUsableSpace(this.context.getExternalFilesDir(null)));
        $this$fetch_u24lambda_u240.setFreeRamMemory(this.getFreeMemory());
        $this$fetch_u24lambda_u240.setWiredHeadset(this.isWiredHeadsetOn());
        $this$fetch_u24lambda_u240.setTimeZone(this.getTimeZone());
        $this$fetch_u24lambda_u240.setTimeZoneOffset(this.getTimeZoneOffset());
        $this$fetch_u24lambda_u240.setLimitedTracking(this.isLimitAdTrackingEnabled());
        $this$fetch_u24lambda_u240.setLimitedOpenAdTracking(this.isLimitOpenAdTrackingEnabled());
        $this$fetch_u24lambda_u240.setBatteryLevel(this.getBatteryLevel());
        $this$fetch_u24lambda_u240.setBatteryStatus(this.getBatteryStatus());
        $this$fetch_u24lambda_u240.setConnectionType(this.getConnectionType());
        $this$fetch_u24lambda_u240.setAndroid(this.fetchAndroidDynamicDeviceInfo());
        $this$fetch_u24lambda_u240.setAppActive(this.isAppActive());
        return dsl._build();
    }

    private final DynamicDeviceInfoOuterClass.DynamicDeviceInfo.Android fetchAndroidDynamicDeviceInfo() {
        DynamicDeviceInfoKt.AndroidKt.Dsl dsl;
        DynamicDeviceInfoKt this_$iv = DynamicDeviceInfoKt.INSTANCE;
        boolean bl = false;
        DynamicDeviceInfoOuterClass.DynamicDeviceInfo.Android.Builder builder = DynamicDeviceInfoOuterClass.DynamicDeviceInfo.Android.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        DynamicDeviceInfoKt.AndroidKt.Dsl $this$android_u24lambda_u240$iv = dsl = DynamicDeviceInfoKt.AndroidKt.Dsl.Companion._create(builder);
        boolean bl2 = false;
        DynamicDeviceInfoKt.AndroidKt.Dsl $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241 = $this$android_u24lambda_u240$iv;
        boolean bl3 = false;
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setNetworkConnected(this.isActiveNetworkConnected());
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setNetworkType(this.getNetworkType());
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setNetworkMetered(this.getNetworkMetered());
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setTelephonyManagerNetworkType(this.getNetworkType());
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setAdbEnabled(this.isAdbEnabled());
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setUsbConnected(this.isUSBConnected());
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setVolume(this.getStreamVolume(3));
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setMaxVolume(this.getStreamMaxVolume(3));
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setDeviceElapsedRealtime(this.getElapsedRealtime());
        $this$fetchAndroidDynamicDeviceInfo_u24lambda_u241.setDeviceUpTime(this.getUptime());
        return dsl._build();
    }

    private final String getLanguage() {
        String string = Locale.getDefault().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefault().toString()");
        return string;
    }

    private final String getTimeZone() {
        String string;
        try {
            String string2 = TimeZone.getDefault().getDisplayName(false, 0, Locale.US);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            TimeZone.g\u2026ORT, Locale.US)\n        }");
            string = string2;
        }
        catch (AssertionError assertionError) {
            Object[] objectArray = new Object[]{((Throwable)((Object)assertionError)).getMessage()};
            DeviceLog.error("Could not read timeZone information: %s", objectArray);
            string = "";
        }
        return string;
    }

    private final long getTimeZoneOffset() {
        return (long)TimeZone.getDefault().getOffset(System.currentTimeMillis()) / (long)1000;
    }

    private final boolean isUsingWifi() {
        ConnectivityManager connectivityManager = this.getConnectivityManager();
        if (connectivityManager == null) {
            return false;
        }
        ConnectivityManager connectivity = connectivityManager;
        TelephonyManager telephony = this.getTelephonyManager();
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        if (info == null || !connectivity.getBackgroundDataSetting() || !info.isConnected() || telephony == null) {
            return false;
        }
        int netType = info.getType();
        return netType == 1 && info.isConnected();
    }

    private final DynamicDeviceInfoOuterClass.ConnectionType getConnectionType() {
        return this.isUsingWifi() ? DynamicDeviceInfoOuterClass.ConnectionType.CONNECTION_TYPE_WIFI : (this.isActiveNetworkConnected() ? DynamicDeviceInfoOuterClass.ConnectionType.CONNECTION_TYPE_CELLULAR : DynamicDeviceInfoOuterClass.ConnectionType.CONNECTION_TYPE_UNSPECIFIED);
    }

    @Deprecated(message="This method was deprecated in API level 30. Use getDataNetworkType()")
    @SuppressLint(value={"MissingPermission"})
    private final int getNetworkType() {
        TelephonyManager telephony = this.getTelephonyManager();
        try {
            TelephonyManager telephonyManager = telephony;
            return telephonyManager != null ? telephonyManager.getNetworkType() : -1;
        }
        catch (SecurityException ex) {
            if (!Intrinsics.areEqual(((Map)this.reportedWarning.getValue()).get("getNetworkType"), (Object)true)) {
                MutableStateFlow<Map<String, Boolean>> mutableStateFlow = this.reportedWarning;
                mutableStateFlow.setValue((Object)MapsKt.plus((Map)((Map)mutableStateFlow.getValue()), (Pair)TuplesKt.to((Object)"getNetworkType", (Object)true)));
                DeviceLog.warning("Unity Ads was not able to get current network type due to missing permission");
            }
            return -1;
        }
    }

    private final boolean getNetworkMetered() {
        ConnectivityManager connectivity;
        ConnectivityManager connectivityManager = connectivity = this.getConnectivityManager();
        return connectivityManager != null ? connectivityManager.isActiveNetworkMetered() : false;
    }

    private final String getNetworkOperator() {
        TelephonyManager telephony;
        TelephonyManager telephonyManager = telephony = this.getTelephonyManager();
        String string = telephonyManager != null ? telephonyManager.getNetworkOperator() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getNetworkOperatorName() {
        TelephonyManager telephony;
        TelephonyManager telephonyManager = telephony = this.getTelephonyManager();
        String string = telephonyManager != null ? telephonyManager.getNetworkOperatorName() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getNetworkCountryISO() {
        TelephonyManager telephony;
        TelephonyManager telephonyManager = telephony = this.getTelephonyManager();
        String string = telephonyManager != null ? telephonyManager.getNetworkCountryIso() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final boolean isActiveNetworkConnected() {
        ConnectivityManager connectivity;
        ConnectivityManager connectivityManager = connectivity = this.getConnectivityManager();
        NetworkInfo activeNetwork = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return activeNetwork != null && activeNetwork.isConnected();
    }

    private final boolean isWiredHeadsetOn() {
        AudioManager audio;
        AudioManager audioManager = audio = this.getAudioManager();
        return audioManager != null ? audioManager.isWiredHeadsetOn() : false;
    }

    @Override
    public int getRingerMode() {
        AudioManager audio;
        AudioManager audioManager = audio = this.getAudioManager();
        return audioManager != null ? audioManager.getRingerMode() : -2;
    }

    private final double getStreamVolume(int streamType) {
        AudioManager audio;
        AudioManager audioManager = audio = this.getAudioManager();
        return audioManager != null ? audioManager.getStreamVolume(streamType) : -2;
    }

    public final double getStreamMaxVolume(int streamType) {
        AudioManager audio;
        AudioManager audioManager = audio = this.getAudioManager();
        return audioManager != null ? audioManager.getStreamMaxVolume(streamType) : -2;
    }

    public final int getScreenBrightness() {
        return Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"screen_brightness", (int)-1);
    }

    @Deprecated(message="Legacy method, migrated from to .getUsableSpace()")
    private final long getFreeSpace(File file) {
        return file != null && file.exists() ? (long)MathKt.roundToInt((float)(file.getFreeSpace() / (long)1024)) : -1L;
    }

    private final long getUsableSpace(File file) {
        return file != null && file.exists() ? (long)MathKt.roundToInt((float)(file.getUsableSpace() / (long)1024)) : -1L;
    }

    private final double getBatteryLevel() {
        Intent i = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (i != null) {
            int level = i.getIntExtra("level", 0);
            int scale = i.getIntExtra("scale", 0);
            return (double)level / (double)scale;
        }
        return -1.0;
    }

    private final int getBatteryStatus() {
        Intent i = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (i != null) {
            return i.getIntExtra("status", 0);
        }
        return -1;
    }

    public final long getTotalMemory() {
        return this.getMemoryInfo(Device.MemoryInfoType.TOTAL_MEMORY);
    }

    public final long getFreeMemory() {
        return this.getMemoryInfo(Device.MemoryInfoType.FREE_MEMORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getMemoryInfo(Device.MemoryInfoType infoType) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[infoType.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = -1;
            }
        }
        int lineNumber = n;
        String line = null;
        Closeable closeable = new RandomAccessFile(DIRECTORY_MEM_INFO, DIRECTORY_MODE_READ);
        Throwable throwable = null;
        try {
            RandomAccessFile it = (RandomAccessFile)closeable;
            boolean bl = false;
            for (int i = 0; i < lineNumber; ++i) {
                line = it.readLine();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this.getMemoryValueFromString(line);
    }

    private final long getMemoryValueFromString(String memVal) {
        if (memVal != null) {
            Pattern p = Pattern.compile("(\\d+)");
            Matcher m = p.matcher(memVal);
            String value = null;
            while (m.find()) {
                value = m.group(1);
            }
            String string = value;
            return string != null ? Long.parseLong(string) : -1L;
        }
        return -1L;
    }

    private final boolean isAdbEnabled() {
        return this.adbStatus();
    }

    private final boolean adbStatus() {
        Boolean status = null;
        try {
            status = 1 == Settings.Global.getInt((ContentResolver)this.context.getContentResolver(), (String)"adb_enabled", (int)0);
        }
        catch (Exception e) {
            DeviceLog.exception("Problems fetching adb enabled status", e);
        }
        Boolean bl = status;
        return bl != null ? bl : false;
    }

    private final boolean isUSBConnected() {
        Intent intent = this.context.registerReceiver(null, new IntentFilter(INTENT_USB_STATE));
        if (intent != null) {
            return intent.getBooleanExtra(USB_EXTRA_CONNECTED, false);
        }
        return false;
    }

    private final long getUptime() {
        return SystemClock.uptimeMillis();
    }

    private final long getElapsedRealtime() {
        return SystemClock.elapsedRealtime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, String> getProcessInfo() {
        HashMap retData = new HashMap();
        Closeable closeable = new RandomAccessFile(DIRECTORY_PROCESS_INFO, DIRECTORY_MODE_READ);
        Throwable throwable = null;
        try {
            RandomAccessFile it = (RandomAccessFile)closeable;
            boolean bl = false;
            String statContent = it.readLine();
            Map map2 = retData;
            Intrinsics.checkNotNullExpressionValue((Object)statContent, (String)"statContent");
            map2.put(KEY_STAT_CONTENT, statContent);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return retData;
    }

    private final boolean isLimitAdTrackingEnabled() {
        return AdvertisingId.getLimitedAdTracking();
    }

    private final boolean isLimitOpenAdTrackingEnabled() {
        return OpenAdvertisingId.getLimitedOpenAdTracking();
    }

    private final boolean isAppActive() {
        return this.lifecycleCache.isAppActive();
    }

    private final long getEventTimeStamp() {
        return System.currentTimeMillis() / (long)1000;
    }

    private final TelephonyManager getTelephonyManager() {
        Object object = this.context.getSystemService("phone");
        return object instanceof TelephonyManager ? (TelephonyManager)object : null;
    }

    private final ConnectivityManager getConnectivityManager() {
        Object object = this.context.getSystemService("connectivity");
        return object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
    }

    private final AudioManager getAudioManager() {
        Object object = this.context.getSystemService("audio");
        return object instanceof AudioManager ? (AudioManager)object : null;
    }

    @Override
    public boolean hasInternet() {
        return Build.VERSION.SDK_INT >= 23 ? this.hasInternetConnectionM() : this.hasInternetConnection();
    }

    private final boolean hasInternetConnection() {
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = this.getConnectivityManager();
        if (connectivityManager == null) {
            return false;
        }
        ConnectivityManager connectivityManager2 = connectivityManager;
        NetworkInfo networkInfo2 = networkInfo = connectivityManager2.getActiveNetworkInfo();
        return networkInfo2 != null ? networkInfo2.isConnected() : false;
    }

    @RequiresApi(api=23)
    private final boolean hasInternetConnectionM() {
        ConnectivityManager connectivityManager = this.getConnectivityManager();
        if (connectivityManager == null) {
            return false;
        }
        ConnectivityManager connectivityManager2 = connectivityManager;
        Network network = connectivityManager2.getActiveNetwork();
        NetworkCapabilities capabilities = connectivityManager2.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasCapability(12) && capabilities.hasCapability(16);
    }

    @Override
    @NotNull
    public Flow<VolumeSettingsChange> getVolumeSettingsChange() {
        return this.volumeSettingsChange;
    }

    @Override
    @NotNull
    public String getOrientation() {
        String string;
        String string2;
        Integer n;
        Context context = this.context;
        Activity activity = context instanceof Activity ? (Activity)context : null;
        Activity activity2 = activity;
        Integer n2 = n = activity2 != null && (activity2 = activity2.getWindowManager()) != null && (activity2 = activity2.getDefaultDisplay()) != null ? Integer.valueOf(activity2.getRotation()) : null;
        if (n2 != null && n2 == 0) {
            string2 = "portrait";
        } else {
            Integer n3 = n;
            int n4 = 1;
            if (n3 != null && n3 == n4) {
                string2 = "landscape";
            } else {
                Integer n5 = n;
                n4 = 2;
                if (n5 != null && n5 == n4) {
                    string2 = "reversePortrait";
                } else {
                    Integer n6 = n;
                    n4 = 3;
                    string2 = string = n6 != null && n6 == n4 ? "reverseLandscape" : null;
                }
            }
        }
        if (string2 == null) {
            switch (this.context.getResources().getConfiguration().orientation) {
                case 1: {
                    string = "portrait";
                    break;
                }
                case 2: {
                    string = "landscape";
                    break;
                }
                default: {
                    string = "unknown";
                }
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String getConnectionTypeStr() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$1[this.getConnectionType().ordinal()]) {
            case 1: {
                string = "wifi";
                break;
            }
            case 2: {
                string = "cellular";
                break;
            }
            case 3: {
                string = "none";
                break;
            }
            default: {
                string = "none";
            }
        }
        return string;
    }

    public static final /* synthetic */ double access$getStreamVolume(AndroidDynamicDeviceInfoDataSource $this, int streamType) {
        return $this.getStreamVolume(streamType);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/unity3d/ads/core/data/datasource/AndroidDynamicDeviceInfoDataSource$Companion;", "", "()V", "DIRECTORY_MEM_INFO", "", "DIRECTORY_MODE_READ", "DIRECTORY_PROCESS_INFO", "INTENT_USB_STATE", "KEY_STAT_CONTENT", "USB_EXTRA_CONNECTED", "unity-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Device.MemoryInfoType.values().length];
            try {
                nArray[Device.MemoryInfoType.TOTAL_MEMORY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Device.MemoryInfoType.FREE_MEMORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DynamicDeviceInfoOuterClass.ConnectionType.values().length];
            try {
                nArray[DynamicDeviceInfoOuterClass.ConnectionType.CONNECTION_TYPE_WIFI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DynamicDeviceInfoOuterClass.ConnectionType.CONNECTION_TYPE_CELLULAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DynamicDeviceInfoOuterClass.ConnectionType.CONNECTION_TYPE_UNSPECIFIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

