package com.unity3d.ads.core.extensions

import com.unity3d.ads.core.data.model.InitializationStateString
import com.unity3d.services.core.properties.SdkProperties.InitializationState

fun InitializationState.getInitializationStateString(): InitializationStateString {
    return when (this) {
        InitializationState.NOT_INITIALIZED -> InitializationStateString.not_initialized
        InitializationState.INITIALIZING -> InitializationStateString.initializing
        InitializationState.INITIALIZED_SUCCESSFULLY -> InitializationStateString.initialized_successfully
        InitializationState.INITIALIZED_FAILED -> InitializationStateString.initialized_failed
    }
}