package com.unity3d.ads.core.domain.events

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.repository.CampaignStateRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.extensions.toByteString
import gateway.v1.OperativeEventRequestOuterClass.OperativeEventRequest
import gateway.v1.OperativeEventRequestOuterClass.OperativeEventType
import gateway.v1.operativeEventRequest
import java.util.UUID

internal class GetOperativeEventRequest(
    private val deviceInfoRepository: DeviceInfoRepository,
    private val sessionRepository: SessionRepository,
    private val campaignStateRepository: CampaignStateRepository) {

    suspend operator fun invoke(
        operativeEventType: OperativeEventType,
        loadTrackingToken: ByteString,
        opportunityId: ByteString,
        additionalEventData: ByteString,
        playerServerId: String?
    ) : OperativeEventRequest {
        return operativeEventRequest {
            eventId = UUID.randomUUID().toByteString()
            eventType = operativeEventType
            impressionOpportunityId = opportunityId
            trackingToken = loadTrackingToken
            additionalData = additionalEventData
            playerServerId?.let { sid = it }
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            sessionCounters = sessionRepository.sessionCounters
            campaignState = campaignStateRepository.getCampaignState()
        }
    }
}