package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.repository.CampaignStateRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import gateway.v1.UniversalRequestKt
import gateway.v1.UniversalRequestOuterClass.UniversalRequest
import gateway.v1.adDataRefreshRequest
import gateway.v1.campaignState

internal class GetAndroidAdDataRefreshRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val campaignStateRepository: CampaignStateRepository,
) : GetAdDataRefreshRequest {
    override suspend fun invoke(
        opportunityId: ByteString,
        refreshToken: ByteString
    ): UniversalRequest {
        val request = adDataRefreshRequest {
            sessionCounters = sessionRepository.sessionCounters
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            impressionOpportunityId = opportunityId
            campaignState = campaignStateRepository.getCampaignState()
            if (!refreshToken.isEmpty) adDataRefreshToken = refreshToken
        }
        val payload = UniversalRequestKt.payload {
            adDataRefreshRequest = request
        }
        return getUniversalRequestForPayLoad(payload)
    }
}