package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.datasource.VolumeSettingsChange
import gateway.v1.AllowedPiiOuterClass.AllowedPii
import gateway.v1.DynamicDeviceInfoOuterClass.DynamicDeviceInfo
import gateway.v1.PiiOuterClass.Pii
import gateway.v1.StaticDeviceInfoOuterClass.StaticDeviceInfo
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.MutableStateFlow

internal interface DeviceInfoRepository {
    val allowedPii: MutableStateFlow<AllowedPii>
    suspend fun staticDeviceInfo(): StaticDeviceInfo
    val dynamicDeviceInfo: DynamicDeviceInfo
    val piiData: Pii
    val volumeSettingsChange: Flow<VolumeSettingsChange>
    suspend fun getIdfi(): ByteString
    suspend fun getAuid(): ByteString
    val analyticsUserId: String?
    val ringerMode: Int
    val orientation: String
    val connectionTypeStr: String
    val appName: String
    val model: String
    val manufacturer: String
    val osVersion: String
    val hasInternet: Boolean
}