package com.unity3d.ads.core.data.model

import com.unity3d.ads.UnityAds

enum class ShowStatus {
    COMPLETED,
    SKIPPED,
    ERROR;

    fun toUnityAdsShowCompletionState(): UnityAds.UnityAdsShowCompletionState = when (this) {
        ShowStatus.COMPLETED -> UnityAds.UnityAdsShowCompletionState.COMPLETED
        ShowStatus.SKIPPED -> UnityAds.UnityAdsShowCompletionState.SKIPPED
        else -> {
            throw IllegalStateException("Unexpected show status: $this")
        }
    }
}