/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.IUnityBannerListener;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.banners.properties.BannerRefreshInfo;
import com.unity3d.services.banners.view.BannerPosition;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.properties.ClientProperties;
import java.util.concurrent.TimeUnit;

public final class UnityBanners {
    private static UnityBanners instance;
    private IUnityBannerListener _bannerListener;
    private BannerPosition _currentBannerPosition = BannerPosition.NONE;
    private BannerWrapper _currentBannerWrapper;

    private static UnityBanners getInstance() {
        if (instance == null) {
            instance = new UnityBanners();
        }
        return instance;
    }

    private UnityBanners() {
    }

    private void _loadBanner(Activity activity, String placementId) {
        if (this._currentBannerWrapper == null) {
            BannerAdRefreshView bannerAdRefreshView = new BannerAdRefreshView(activity, placementId, new UnityBannerSize(320, 50));
            final BannerWrapper bannerWrapper = new BannerWrapper((Context)activity, bannerAdRefreshView);
            bannerWrapper.setBannerPosition(this._currentBannerPosition);
            this._currentBannerWrapper = bannerWrapper;
            final UnityBanners self = this;
            bannerAdRefreshView.setListener(new BannerView.Listener(){

                @Override
                public void onBannerLoaded(BannerView bannerView) {
                    if (self._bannerListener != null) {
                        self._bannerListener.onUnityBannerLoaded(bannerView.getPlacementId(), (View)bannerWrapper);
                    }
                }

                @Override
                public void onBannerFailedToLoad(BannerView bannerView, BannerErrorInfo errorInfo) {
                    if (self._bannerListener != null) {
                        self._bannerListener.onUnityBannerError(bannerView.getPlacementId() + " " + errorInfo.errorMessage);
                    }
                }

                @Override
                public void onBannerClick(BannerView bannerView) {
                    if (self._bannerListener != null) {
                        self._bannerListener.onUnityBannerClick(bannerView.getPlacementId());
                    }
                }
            });
            bannerAdRefreshView.load();
        } else {
            UnityBanners.sendError("A Banner is already in use, please call destroy before loading another banner!");
        }
    }

    private void _destroy() {
        if (this._currentBannerWrapper != null) {
            this._currentBannerWrapper.destroy();
            this._currentBannerWrapper = null;
        }
    }

    private static void sendError(final String message) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                IUnityBannerListener listener2 = UnityBanners.getBannerListener();
                if (listener2 != null) {
                    listener2.onUnityBannerError(message);
                }
            }
        });
    }

    @Deprecated
    public static void loadBanner(Activity activity, String placementId) {
        DeviceLog.entered();
        if (!UnityAds.isSupported()) {
            UnityBanners.sendError("Unity Ads is not supported on this device.");
        }
        if (!UnityAds.isInitialized()) {
            UnityBanners.sendError("UnityAds is not initialized.");
            return;
        }
        ClientProperties.setActivity(activity);
        UnityBanners.getInstance()._loadBanner(activity, placementId);
    }

    @Deprecated
    public static void destroy() {
        UnityBanners.getInstance()._destroy();
    }

    @Deprecated
    public static void setBannerListener(IUnityBannerListener listener2) {
        UnityBanners.getInstance()._bannerListener = listener2;
    }

    @Deprecated
    public static IUnityBannerListener getBannerListener() {
        return UnityBanners.getInstance()._bannerListener;
    }

    @Deprecated
    public static void setBannerPosition(BannerPosition position) {
        UnityBanners.getInstance()._currentBannerPosition = position;
    }

    private class BannerAdRefreshView
    extends RelativeLayout {
        private String placementId;
        private boolean didLoad;
        private long refreshRate;
        private BannerView bannerView;
        private boolean didShow;
        private boolean didSubscribeToLifecycle;
        private LifecycleListener lifecycleListener;
        private Handler refreshHandler;
        private Runnable reloadRunnable;
        private long refreshTime;

        public BannerAdRefreshView(Activity activity, String placementId, UnityBannerSize size) {
            super((Context)activity);
            this.didLoad = false;
            this.refreshRate = 30L;
            this.didShow = false;
            this.didSubscribeToLifecycle = false;
            this.placementId = placementId;
            this.refreshHandler = new Handler();
            final BannerAdRefreshView self = this;
            this.reloadRunnable = new Runnable(){

                @Override
                public void run() {
                    self.reload();
                }
            };
            this.setupLayoutParams();
            this.setBackgroundColor(0);
            this.bannerView = new BannerView(activity, placementId, size);
            this.addView((View)this.bannerView);
        }

        public String getPlacementId() {
            return this.bannerView.getPlacementId();
        }

        public UnityBannerSize getSize() {
            return this.bannerView.getSize();
        }

        public void setListener(BannerView.IListener listener2) {
            this.bannerView.setListener(listener2);
        }

        public BannerView.IListener getListener() {
            return this.bannerView.getListener();
        }

        public void load() {
            if (!this.didLoad) {
                this.didLoad = true;
                Integer refreshRateInteger = BannerRefreshInfo.getInstance().getRefreshRate(this.placementId);
                if (refreshRateInteger != null) {
                    this.refreshRate = refreshRateInteger.longValue();
                }
                this.reload();
            }
        }

        public void destroy() {
            this.stopReloadTask();
            this.bannerView.destroy();
            final BannerAdRefreshView self = this;
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    self.removeAllViews();
                }
            });
            this.bannerView = null;
        }

        private void startReloadTask() {
            long currentTime = SystemClock.uptimeMillis();
            if (currentTime < this.refreshTime) {
                this.refreshHandler.postAtTime(this.reloadRunnable, this.refreshTime);
            } else {
                this.reload();
            }
        }

        private void stopReloadTask() {
            if (this.refreshHandler != null && this.reloadRunnable != null) {
                this.refreshHandler.removeCallbacks(this.reloadRunnable);
            }
        }

        private void reload() {
            this.bannerView.load();
            long currentTime = SystemClock.uptimeMillis();
            this.refreshTime = currentTime + TimeUnit.SECONDS.toMillis(this.refreshRate);
            this.refreshHandler.postAtTime(this.reloadRunnable, this.refreshTime);
        }

        private void subscribeToLifecycle() {
            if (!this.didSubscribeToLifecycle && Build.VERSION.SDK_INT >= 14 && ClientProperties.getApplication() != null) {
                final BannerAdRefreshView self = this;
                this.lifecycleListener = new LifecycleListener(){

                    @Override
                    public void onActivityPaused(Activity activity) {
                        self.stopReloadTask();
                    }

                    @Override
                    public void onActivityStopped(Activity activity) {
                        self.stopReloadTask();
                    }

                    @Override
                    public void onActivityDestroyed(Activity activity) {
                        self.stopReloadTask();
                    }

                    @Override
                    public void onActivityResumed(Activity activity) {
                        self.startReloadTask();
                    }
                };
                this.didSubscribeToLifecycle = true;
                ClientProperties.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.lifecycleListener);
            }
        }

        private void unsubscribeFromLifecycle() {
            if (this.didSubscribeToLifecycle && Build.VERSION.SDK_INT >= 14 && this.lifecycleListener != null && ClientProperties.getApplication() != null) {
                this.didSubscribeToLifecycle = false;
                ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.lifecycleListener);
            }
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.stopReloadTask();
            this.unsubscribeFromLifecycle();
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.subscribeToLifecycle();
            if (this.didShow) {
                this.startReloadTask();
            } else {
                this.didShow = true;
            }
        }

        private void setupLayoutParams() {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }

        @TargetApi(value=14)
        private class LifecycleListener
        implements Application.ActivityLifecycleCallbacks {
            private LifecycleListener() {
            }

            public void onActivityCreated(Activity activity, Bundle bundle) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        }
    }

    private class BannerWrapper
    extends FrameLayout {
        private BannerPosition _bannerPosition;
        private BannerAdRefreshView _bannerAdRefreshView;

        public BannerWrapper(Context context, BannerAdRefreshView bannerAdRefreshView) {
            super(context);
            this._bannerPosition = BannerPosition.NONE;
            this._bannerAdRefreshView = bannerAdRefreshView;
            this.addView((View)this._bannerAdRefreshView);
            this.setupLayoutConstraints();
            this.setBackgroundColor(0);
        }

        public void setBannerPosition(BannerPosition bannerPosition) {
            this._bannerPosition = bannerPosition;
            this.setupLayoutConstraints();
        }

        private void setupLayoutConstraints() {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.gravity = this._bannerPosition.getGravity();
            this.setLayoutParams((ViewGroup.LayoutParams)params);
        }

        public void destroy() {
            final BannerWrapper bannerWrapper = this;
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    bannerWrapper.removeAllViews();
                    ViewUtilities.removeViewFromParent((View)bannerWrapper);
                }
            });
            if (this._bannerAdRefreshView != null) {
                this._bannerAdRefreshView.destroy();
                this._bannerAdRefreshView = null;
            }
        }
    }
}

