/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners;

import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.load.LoadBannerModule;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.core.misc.Utilities;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class BannerViewCache {
    private static BannerViewCache instance;
    private HashMap<String, WeakReference<BannerView>> _bannerViews = new HashMap();

    public static BannerViewCache getInstance() {
        if (instance == null) {
            instance = new BannerViewCache();
        }
        return instance;
    }

    public synchronized String addBannerView(BannerView bannerAdView) {
        WeakReference<BannerView> weakBannerView = new WeakReference<BannerView>(bannerAdView);
        this._bannerViews.put(bannerAdView.getViewId(), weakBannerView);
        return bannerAdView.getViewId();
    }

    public synchronized BannerView getBannerView(String bannerAdId) {
        WeakReference<BannerView> weakBannerView = this._bannerViews.get(bannerAdId);
        if (weakBannerView != null && weakBannerView.get() != null) {
            return (BannerView)((Object)weakBannerView.get());
        }
        return null;
    }

    public synchronized void removeBannerView(String bannerAdId) {
        this._bannerViews.remove(bannerAdId);
    }

    public synchronized boolean loadWebPlayer(String bannerAdId, UnityBannerSize size) {
        BannerView bannerView = this.getBannerView(bannerAdId);
        if (bannerView != null) {
            bannerView.loadWebPlayer(size);
            return true;
        }
        return false;
    }

    public synchronized void triggerBannerLoadEvent(String bannerAdId) {
        final BannerView bannerView = this.getBannerView(bannerAdId);
        if (bannerView != null && bannerView.getListener() != null) {
            final BannerView.IListener listener2 = bannerView.getListener();
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (listener2 != null) {
                        listener2.onBannerLoaded(bannerView);
                    }
                }
            });
        }
    }

    public synchronized void triggerBannerClickEvent(String bannerAdId) {
        final BannerView bannerView = this.getBannerView(bannerAdId);
        if (bannerView != null && bannerView.getListener() != null) {
            final BannerView.IListener listener2 = bannerView.getListener();
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (listener2 != null) {
                        listener2.onBannerClick(bannerView);
                    }
                }
            });
        }
    }

    public synchronized void triggerBannerErrorEvent(String bannerAdId, BannerErrorInfo bannerErrorInfo) {
        LoadBannerModule.getInstance().onUnityAdsFailedToLoad(bannerAdId, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, bannerErrorInfo.errorMessage);
    }

    public synchronized void triggerBannerLeftApplicationEvent(String bannerAdId) {
        final BannerView bannerView = this.getBannerView(bannerAdId);
        if (bannerView != null && bannerView.getListener() != null) {
            final BannerView.IListener listener2 = bannerView.getListener();
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (listener2 != null) {
                        listener2.onBannerLeftApplication(bannerView);
                    }
                }
            });
        }
    }
}

