/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationRequestFactory;
import com.unity3d.services.core.configuration.IConfigurationLoader;
import com.unity3d.services.core.configuration.IConfigurationLoaderListener;
import com.unity3d.services.core.configuration.IPrivacyConfigurationListener;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.configuration.PrivacyConfig;
import com.unity3d.services.core.configuration.PrivacyConfigStatus;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.WebRequest;
import org.json.JSONObject;

public class PrivacyConfigurationLoader
implements IConfigurationLoader {
    private final IConfigurationLoader _configurationLoader;
    private final ConfigurationRequestFactory _configurationRequestFactory;
    private final PrivacyConfigStorage _privacyConfigStorage;

    public PrivacyConfigurationLoader(IConfigurationLoader configurationLoader, ConfigurationRequestFactory configurationRequestFactory, PrivacyConfigStorage privacyConfigStorage) {
        this._configurationLoader = configurationLoader;
        this._configurationRequestFactory = configurationRequestFactory;
        this._privacyConfigStorage = privacyConfigStorage;
    }

    @Override
    public void loadConfiguration(IConfigurationLoaderListener configurationLoaderListener) throws Exception {
        if (this._privacyConfigStorage.getPrivacyConfig().getPrivacyStatus() == PrivacyConfigStatus.UNKNOWN) {
            this.load(new IPrivacyConfigurationListener(){

                @Override
                public void onSuccess(PrivacyConfig privacyMode) {
                    PrivacyConfigurationLoader.this._privacyConfigStorage.setPrivacyConfig(privacyMode);
                }

                @Override
                public void onError(String errorMsg) {
                    DeviceLog.warning("Couldn't fetch privacy configuration: " + errorMsg);
                    PrivacyConfigurationLoader.this._privacyConfigStorage.setPrivacyConfig(new PrivacyConfig());
                }
            });
        }
        this._configurationLoader.loadConfiguration(configurationLoaderListener);
    }

    @Override
    public Configuration getLocalConfiguration() {
        return this._configurationLoader.getLocalConfiguration();
    }

    private void load(IPrivacyConfigurationListener privacyLoaderListener) throws Exception {
        WebRequest request;
        try {
            request = this._configurationRequestFactory.getWebRequest();
        }
        catch (Exception ex) {
            privacyLoaderListener.onError("Could not create web request: " + ex);
            return;
        }
        InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestStart();
        String response = request.makeRequest();
        try {
            boolean is2XXResponseCode;
            boolean bl = is2XXResponseCode = request.getResponseCode() / 100 == 2;
            if (is2XXResponseCode) {
                InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestEnd(true);
                privacyLoaderListener.onSuccess(new PrivacyConfig(new JSONObject(response)));
            } else {
                InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestEnd(false);
                privacyLoaderListener.onError("Privacy request failed with code: " + request.getResponseCode());
            }
        }
        catch (Exception e) {
            InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestEnd(false);
            privacyLoaderListener.onError("Could not create web request");
        }
    }
}

