/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.timer;

import com.unity3d.services.core.lifecycle.CachedLifecycle;
import com.unity3d.services.core.lifecycle.IAppActiveListener;
import com.unity3d.services.core.lifecycle.LifecycleCache;
import com.unity3d.services.core.lifecycle.LifecycleEvent;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.timer.IBaseTimer;
import com.unity3d.services.core.timer.ITimerListener;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BaseTimer
implements IBaseTimer,
IAppActiveListener {
    private final LifecycleCache _lifecycleCache;
    final Integer _totalDurationMs;
    final Integer _delayMs = 1000;
    Integer _remainingDurationMs;
    private ITimerListener _timerListener;
    private ScheduledFuture<?> _task;
    private ScheduledExecutorService _timerService;
    private final AtomicBoolean _isRunning = new AtomicBoolean(false);
    private final AtomicBoolean _hasPaused = new AtomicBoolean(false);

    public BaseTimer(Integer totalDurationMs, ITimerListener timerListener, LifecycleCache lifecycleCache) {
        this._totalDurationMs = totalDurationMs;
        this._remainingDurationMs = totalDurationMs;
        this._timerListener = timerListener;
        this._lifecycleCache = lifecycleCache;
        if (this._lifecycleCache != null) {
            this._lifecycleCache.addListener(this);
        }
    }

    public BaseTimer(Integer totalDurationMs, ITimerListener timerListener) {
        this(totalDurationMs, timerListener, CachedLifecycle.getLifecycleListener());
    }

    @Override
    public void start(ScheduledExecutorService timerService) {
        if (this._isRunning.compareAndSet(false, true)) {
            this._timerService = timerService;
            this.schedule();
        }
    }

    @Override
    public void stop() {
        if (this._timerService != null && !this._timerService.isShutdown()) {
            this._timerService.shutdown();
            this._timerService = null;
        }
        this._isRunning.getAndSet(false);
    }

    @Override
    public boolean pause() {
        boolean result = false;
        if (this._task != null && !this._task.isCancelled()) {
            this._task.cancel(true);
            this._task = null;
            result = true;
        }
        this._isRunning.getAndSet(false);
        return result;
    }

    @Override
    public boolean resume() {
        boolean result = false;
        if (this._timerService != null && !this._timerService.isShutdown()) {
            result = true;
            this.schedule();
        }
        this._isRunning.getAndSet(result);
        return result;
    }

    public void restart(ScheduledExecutorService timerService) {
        if (this._timerService == null || this._timerService.isShutdown()) {
            this._timerService = timerService;
        }
        this._remainingDurationMs = this._totalDurationMs;
        this.schedule();
        this._isRunning.getAndSet(true);
    }

    @Override
    public void kill() {
        this.stop();
        if (this._lifecycleCache != null) {
            this._lifecycleCache.removeListener(this);
        }
        this._timerListener = null;
    }

    public boolean isRunning() {
        return this._isRunning.get();
    }

    public void onStep() {
        if (this._remainingDurationMs <= 0) {
            this.notifyListeners();
            this.kill();
        }
    }

    private void schedule() {
        try {
            this._task = this._timerService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    BaseTimer.this._remainingDurationMs = BaseTimer.this._remainingDurationMs - BaseTimer.this._delayMs;
                    BaseTimer.this.onStep();
                }
            }, this._delayMs.intValue(), this._delayMs.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException | RejectedExecutionException e) {
            DeviceLog.debug("ERROR: IntervalTimer failed to start due to exception " + e.getLocalizedMessage());
        }
    }

    private void notifyListeners() {
        if (this._timerListener != null) {
            this._timerListener.onTimerFinished();
        }
    }

    @Override
    public void onAppStateChanged(LifecycleEvent event) {
        switch (event) {
            case PAUSED: {
                if (!this.isRunning()) break;
                this.pause();
                this._hasPaused.getAndSet(true);
                break;
            }
            case RESUMED: {
                if (!this._hasPaused.get()) break;
                this._hasPaused.getAndSet(false);
                this.resume();
                break;
            }
        }
    }
}

