/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.ExperimentsBase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class Experiments
extends ExperimentsBase {
    private static final Set<String> NEXT_SESSION_FLAGS = new HashSet<String>(Arrays.asList("tsi", "tsi_upii", "tsi_p", "tsi_nt", "tsi_prr", "tsi_prw"));
    private final JSONObject _experimentData;

    public Experiments() {
        this(null);
    }

    public Experiments(JSONObject experimentData) {
        this._experimentData = experimentData == null ? new JSONObject() : experimentData;
    }

    @Override
    public boolean isTwoStageInitializationEnabled() {
        return this._experimentData.optBoolean("tsi", true);
    }

    @Override
    public boolean isForwardExperimentsToWebViewEnabled() {
        return this._experimentData.optBoolean("fff", false);
    }

    @Override
    public boolean isNativeTokenEnabled() {
        return this._experimentData.optBoolean("tsi_nt", true);
    }

    @Override
    public boolean isUpdatePiiFields() {
        return this._experimentData.optBoolean("tsi_upii", false);
    }

    @Override
    public boolean isPrivacyRequestEnabled() {
        return this._experimentData.optBoolean("tsi_prr", true);
    }

    @Override
    public boolean shouldNativeTokenAwaitPrivacy() {
        return this._experimentData.optBoolean("tsi_prw", false);
    }

    @Override
    public boolean isNativeWebViewCacheEnabled() {
        return this._experimentData.optBoolean("nwc", false);
    }

    @Override
    public boolean isWebAssetAdCaching() {
        return this._experimentData.optBoolean("wac", false);
    }

    @Override
    public boolean isWebGestureNotRequired() {
        return this._experimentData.optBoolean("wgr", false);
    }

    @Override
    public boolean isNewLifecycleTimer() {
        return this._experimentData.optBoolean("nlt", false);
    }

    @Override
    public JSONObject getExperimentsAsJson() {
        return this._experimentData;
    }

    @Override
    public Map<String, String> getExperimentTags() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keyItor = this._experimentData.keys();
        while (keyItor.hasNext()) {
            String key = (String)keyItor.next();
            map.put(key, String.valueOf(this._experimentData.opt(key)));
        }
        return map;
    }

    @Override
    public JSONObject getNextSessionExperiments() {
        if (this._experimentData == null) {
            return null;
        }
        HashMap<String, String> nextSessionFlags = new HashMap<String, String>();
        Iterator it = this._experimentData.keys();
        while (it.hasNext()) {
            String currentKey = (String)it.next();
            if (!NEXT_SESSION_FLAGS.contains(currentKey)) continue;
            nextSessionFlags.put(currentKey, String.valueOf(this._experimentData.optBoolean(currentKey)));
        }
        return new JSONObject(nextSessionFlags);
    }

    @Override
    public JSONObject getCurrentSessionExperiments() {
        if (this._experimentData == null) {
            return null;
        }
        HashMap<String, String> currentSessionFlags = new HashMap<String, String>();
        Iterator it = this._experimentData.keys();
        while (it.hasNext()) {
            String currentKey = (String)it.next();
            if (NEXT_SESSION_FLAGS.contains(currentKey)) continue;
            currentSessionFlags.put(currentKey, String.valueOf(this._experimentData.optBoolean(currentKey)));
        }
        return new JSONObject(currentSessionFlags);
    }
}

