/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.InitRequestType;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.Storage;
import com.unity3d.services.core.device.StorageManager;
import com.unity3d.services.core.device.reader.DeviceInfoReaderBuilder;
import com.unity3d.services.core.device.reader.DeviceInfoReaderFilterProvider;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithFilter;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithStorageInfo;
import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.misc.JsonFlattenerRules;
import java.util.Arrays;
import java.util.Collections;

public class DeviceInfoReaderPrivacyBuilder
extends DeviceInfoReaderBuilder {
    public DeviceInfoReaderPrivacyBuilder(ConfigurationReader configurationReader, PrivacyConfigStorage privacyConfigStorage) {
        super(configurationReader, privacyConfigStorage);
    }

    @Override
    public IDeviceInfoReader build() {
        Storage privateStorage = StorageManager.getStorage(StorageManager.StorageType.PRIVATE);
        Storage publicStorage = StorageManager.getStorage(StorageManager.StorageType.PUBLIC);
        DeviceInfoReaderFilterProvider deviceInfoReaderFilterProvider = new DeviceInfoReaderFilterProvider(privateStorage);
        IDeviceInfoReader deviceInfoReader = this.buildWithRequestType(InitRequestType.PRIVACY);
        DeviceInfoReaderWithStorageInfo deviceInfoReaderWithStorageInfo = new DeviceInfoReaderWithStorageInfo(deviceInfoReader, this.getPrivacyRequestStorageRules(), privateStorage, publicStorage);
        return new DeviceInfoReaderWithFilter(deviceInfoReaderWithStorageInfo, deviceInfoReaderFilterProvider.getFilterList());
    }

    private JsonFlattenerRules getPrivacyRequestStorageRules() {
        return new JsonFlattenerRules(Arrays.asList("privacy", "gdpr", "unity", "pipl"), Collections.singletonList("value"), Arrays.asList("ts", "exclude", "mode"));
    }
}

