/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request.metrics;

import android.text.TextUtils;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.metrics.IMetricSenderWithBatch;
import com.unity3d.services.core.request.metrics.ISDKMetrics;
import com.unity3d.services.core.request.metrics.Metric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class MetricSenderWithBatch
implements IMetricSenderWithBatch {
    private final LinkedBlockingQueue<Metric> _queue = new LinkedBlockingQueue();
    private ISDKMetrics _original;

    public MetricSenderWithBatch(ISDKMetrics metrics) {
        this._original = metrics;
    }

    @Override
    public void updateOriginal(ISDKMetrics metrics) {
        this._original = metrics;
    }

    @Override
    public void sendEvent(String event) {
        this.sendEvent(event, null);
    }

    @Override
    public void sendEvent(String event, String value, Map<String, String> tags) {
        if (event == null || event.isEmpty()) {
            DeviceLog.debug("Metric event not sent due to being null or empty: " + event);
            return;
        }
        this.sendMetrics(new ArrayList<Metric>(Collections.singletonList(new Metric(event, value, tags))));
    }

    @Override
    public void sendEvent(String event, Map<String, String> tags) {
        this.sendEvent(event, null, tags);
    }

    @Override
    public void sendMetric(Metric metric) {
        this.sendMetrics(new ArrayList<Metric>(Collections.singletonList(metric)));
    }

    @Override
    public synchronized void sendMetrics(List<Metric> metrics) {
        this._queue.addAll(metrics);
        if (!TextUtils.isEmpty((CharSequence)this._original.getMetricEndPoint()) && this._queue.size() > 0) {
            ArrayList<Metric> eventsToSend = new ArrayList<Metric>();
            this._queue.drainTo(eventsToSend);
            this._original.sendMetrics(eventsToSend);
        }
    }

    @Override
    public String getMetricEndPoint() {
        return this._original == null ? null : this._original.getMetricEndPoint();
    }

    @Override
    public void sendQueueIfNeeded() {
        this.sendMetrics(new ArrayList<Metric>());
    }
}

