/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview.bridge;

import android.net.Uri;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.webkit.JavaScriptReplyProxy;
import androidx.webkit.WebMessageCompat;
import com.unity3d.ads.core.extensions.JSONArrayExtensionsKt;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.bridge.IInvocationCallbackInvoker;
import com.unity3d.services.core.webview.bridge.IWebViewBridge;
import com.unity3d.services.core.webview.bridge.Invocation;
import com.unity3d.services.core.webview.bridge.SharedInstances;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0007J.\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J.\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unity3d/services/core/webview/bridge/WebViewBridgeInterface;", "", "webViewBridge", "Lcom/unity3d/services/core/webview/bridge/IWebViewBridge;", "webViewAppInvocationCallbackInvoker", "Lcom/unity3d/services/core/webview/bridge/IInvocationCallbackInvoker;", "(Lcom/unity3d/services/core/webview/bridge/IWebViewBridge;Lcom/unity3d/services/core/webview/bridge/IInvocationCallbackInvoker;)V", "handleCallback", "", "callbackId", "", "callbackStatus", "rawParameters", "handleInvocation", "data", "onHandleCallback", "view", "Landroid/webkit/WebView;", "message", "Landroidx/webkit/WebMessageCompat;", "sourceOrigin", "Landroid/net/Uri;", "isMainFrame", "", "replyProxy", "Landroidx/webkit/JavaScriptReplyProxy;", "onHandleInvocation", "unity-ads_defaultRelease"})
public final class WebViewBridgeInterface {
    @NotNull
    private final IWebViewBridge webViewBridge;
    @NotNull
    private final IInvocationCallbackInvoker webViewAppInvocationCallbackInvoker;

    public WebViewBridgeInterface(@NotNull IWebViewBridge webViewBridge2, @NotNull IInvocationCallbackInvoker webViewAppInvocationCallbackInvoker) {
        Intrinsics.checkNotNullParameter((Object)webViewBridge2, (String)"webViewBridge");
        Intrinsics.checkNotNullParameter((Object)webViewAppInvocationCallbackInvoker, (String)"webViewAppInvocationCallbackInvoker");
        this.webViewBridge = webViewBridge2;
        this.webViewAppInvocationCallbackInvoker = webViewAppInvocationCallbackInvoker;
    }

    public /* synthetic */ WebViewBridgeInterface(IWebViewBridge iWebViewBridge, IInvocationCallbackInvoker iInvocationCallbackInvoker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iWebViewBridge = SharedInstances.INSTANCE.getWebViewBridge();
        }
        if ((n & 2) != 0) {
            iInvocationCallbackInvoker = SharedInstances.INSTANCE.getWebViewAppInvocationCallbackInvoker();
        }
        this(iWebViewBridge, iInvocationCallbackInvoker);
    }

    @JavascriptInterface
    public final void handleInvocation(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DeviceLog.debug("handleInvocation " + data);
        JSONArray invocationArray = new JSONArray(data);
        Invocation batch = new Invocation(this.webViewAppInvocationCallbackInvoker, this.webViewBridge);
        int n = invocationArray.length();
        for (int idx = 0; idx < n; ++idx) {
            Object object = invocationArray.get(idx);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONArray");
            JSONArray currentInvocation = (JSONArray)object;
            Object object2 = currentInvocation.get(0);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            String className = (String)object2;
            Object object3 = currentInvocation.get(1);
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
            String methodName = (String)object3;
            Object object4 = currentInvocation.get(2);
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.json.JSONArray");
            JSONArray parameters = (JSONArray)object4;
            Object object5 = currentInvocation.get(3);
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.String");
            String callback2 = (String)object5;
            batch.addInvocation(className, methodName, JSONArrayExtensionsKt.toTypedArray(parameters), new WebViewCallback(callback2, batch.getId()));
            batch.nextInvocation();
        }
        batch.sendInvocationCallback();
    }

    @JavascriptInterface
    public final void handleCallback(@NotNull String callbackId, @NotNull String callbackStatus, @NotNull String rawParameters) {
        Intrinsics.checkNotNullParameter((Object)callbackId, (String)"callbackId");
        Intrinsics.checkNotNullParameter((Object)callbackStatus, (String)"callbackStatus");
        Intrinsics.checkNotNullParameter((Object)rawParameters, (String)"rawParameters");
        DeviceLog.debug("handleCallback " + callbackId + ' ' + callbackStatus + ' ' + rawParameters);
        JSONArray parameters = new JSONArray(rawParameters);
        this.webViewBridge.handleCallback(callbackId, callbackStatus, JSONArrayExtensionsKt.toTypedArray(parameters));
    }

    public final void onHandleInvocation(@NotNull WebView view, @NotNull WebMessageCompat message, @NotNull Uri sourceOrigin, boolean isMainFrame, @NotNull JavaScriptReplyProxy replyProxy) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sourceOrigin, (String)"sourceOrigin");
        Intrinsics.checkNotNullParameter((Object)replyProxy, (String)"replyProxy");
        String data = message.getData();
        if (!isMainFrame || (charSequence = (CharSequence)data) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        this.handleInvocation(data);
    }

    public final void onHandleCallback(@NotNull WebView view, @NotNull WebMessageCompat message, @NotNull Uri sourceOrigin, boolean isMainFrame, @NotNull JavaScriptReplyProxy replyProxy) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sourceOrigin, (String)"sourceOrigin");
        Intrinsics.checkNotNullParameter((Object)replyProxy, (String)"replyProxy");
        String data = message.getData();
        if (!isMainFrame || (charSequence = (CharSequence)data) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        JSONObject parameters = new JSONObject(data);
        String callbackId = parameters.getString("id");
        String callbackStatus = parameters.getString("status");
        String rawParameters = parameters.getString("parameters");
        Intrinsics.checkNotNullExpressionValue((Object)callbackId, (String)"callbackId");
        Intrinsics.checkNotNullExpressionValue((Object)callbackStatus, (String)"callbackStatus");
        Intrinsics.checkNotNullExpressionValue((Object)rawParameters, (String)"rawParameters");
        this.handleCallback(callbackId, callbackStatus, rawParameters);
    }

    public WebViewBridgeInterface() {
        this(null, null, 3, null);
    }
}

