package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.core.reflection.GenericBridge
import com.unity3d.services.store.gpbl.BillingOriginalJsonResponse
import org.json.JSONException
import org.json.JSONObject

class ProductDetailsBridge(private val internalRef: Any): BillingOriginalJsonResponse, GenericBridge(hashMapOf(
        TO_STRING_METHOD to emptyArray()
    )
) {

    override fun toString(): String {
        return callNonVoidMethod(TO_STRING_METHOD, internalRef) as String
    }

    override fun getClassName(): String {
        return "com.android.billingclient.api.ProductDetails"
    }

    override fun getOriginalJson(): JSONObject {
        // Override parent method to prevent reflection call to non-existent v8 method
        // Instead, create the JSON from toString() for v8 compatibility
        return try {
            parseOriginalJson(toString())?.let { JSONObject(it) } ?: JSONObject()
        } catch (e: JSONException) {
            JSONObject()
        }
    }

    private fun parseOriginalJson(productDetailsString: String): String? {
        return try {
            // Find the jsonString='...' portion
            val start = productDetailsString.indexOf("jsonString='") + "jsonString='".length
            val end = productDetailsString.indexOf("', parsedJson=")

            if (start in 1 until end) {
                val originalJson = productDetailsString.substring(start, end)
                    .replace("\\/", "/") // Unescape forward slashes
                originalJson
            } else {
                null
            }
        } catch (e: Exception) {
            null
        }
    }

    companion object {
        private const val TO_STRING_METHOD = "toString"
    }
}