package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import android.content.Context
import com.unity3d.services.store.gpbl.bridges.SkuDetailsParamsBridge
import com.unity3d.services.store.gpbl.bridges.billingclient.common.BillingClientBridgeCommon
import com.unity3d.services.store.gpbl.proxies.ProductDetailsResponseListenerProxy
import com.unity3d.services.store.gpbl.proxies.PurchasesResponseListenerProxy
import com.unity3d.services.store.gpbl.proxies.SkuDetailsResponseListenerProxy
import java.lang.reflect.InvocationTargetException

class BillingClientBridge(billingClientInternalInstance: Any?) : BillingClientBridgeCommon(
    billingClientInternalInstance,
    mapOf(
        QUERY_PURCHASES_ASYNC_METHOD to arrayOf(QueryPurchasesParamsBridge.getClassForParams(), PurchasesResponseListenerProxy.getProxyListenerClass()),
        QUERY_PRODUCT_DETAILS_ASYNC_METHOD to arrayOf(QueryProductDetailsParamsBridge.getClassForParams(), ProductDetailsResponseListenerProxy.getProxyListenerClass())
    )
) {
    @Throws(ClassNotFoundException::class)
    override fun queryPurchasesAsync(
        purchaseType: String?,
        purchasesResponseListenerProxy: PurchasesResponseListenerProxy?
    ) {
        if (purchaseType != null) {
            val purchaseParams = QueryPurchasesParamsBridge.newBuilder().setProductType(purchaseType).build()
            callVoidMethod(
                QUERY_PURCHASES_ASYNC_METHOD,
                _billingClientInternalInstance,
                purchaseParams.queryProductDetailsParamsInternalInstance,
                purchasesResponseListenerProxy!!.proxyInstance
            )
        }
    }

    @Throws(ClassNotFoundException::class)
    override fun querySkuDetailsAsync(
        params: SkuDetailsParamsBridge,
        skuDetailsResponseListenerProxy: SkuDetailsResponseListenerProxy
    ) {
        // Does not exist in Billing Library v8
        throw NoSuchMethodException("querySkuDetailsAsync does not exist in Billing Library v8, use queryProductDetailsAsync instead")
    }

    fun queryProductDetailsAsync(
        queryProductDetailsParamsBridge: QueryProductDetailsParamsBridge,
        productDetailsResponseListenerProxy: ProductDetailsResponseListenerProxy
    ) {
        callVoidMethod(
            QUERY_PRODUCT_DETAILS_ASYNC_METHOD,
            _billingClientInternalInstance,
            queryProductDetailsParamsBridge.queryProductDetailsParamsInternalInstance,
            productDetailsResponseListenerProxy.proxyInstance
        )
    }

    companion object {
        @JvmStatic
        @Throws(
            NoSuchMethodException::class,
            InvocationTargetException::class,
            IllegalAccessException::class,
            ClassNotFoundException::class
        )
        fun newBuilder(context: Context): BillingClientBuilderBridge {
            val billingClientBuilderInternalInstance = callNonVoidStaticMethod(newBuilderMethodName, context)
            return BillingClientBuilderBridge(billingClientBuilderInternalInstance)
        }

        const val QUERY_PURCHASES_ASYNC_METHOD: String = "queryPurchasesAsync"
        const val QUERY_PRODUCT_DETAILS_ASYNC_METHOD: String = "queryProductDetailsAsync"
    }
}