package com.unity3d.services.ads.gmascar;

import com.unity3d.scar.adapter.common.scarads.UnityAdFormat;
import com.unity3d.services.ads.gmascar.adapters.ScarAdapterFactory;
import com.unity3d.services.ads.gmascar.bridges.AdapterStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializationStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializeListenerBridge;
import com.unity3d.services.ads.gmascar.bridges.mobileads.MobileAdsBridgeFactory;
import com.unity3d.services.ads.gmascar.handlers.BiddingSignalsHandler;
import com.unity3d.services.ads.gmascar.handlers.WebViewErrorHandler;
import com.unity3d.services.ads.gmascar.listeners.IBiddingSignalsListener;
import com.unity3d.services.ads.gmascar.utils.GMAEventSender;

import java.util.List;

public class GMA {

	private static GMA instance;
	private final GMAScarAdapterBridge _gmaScarAdapterBridge;

	private GMA(GMAEventSender eventSender) {
		_gmaScarAdapterBridge = new GMAScarAdapterBridge(
			new MobileAdsBridgeFactory().createMobileAdsBridge(),
			new InitializeListenerBridge(),
			new InitializationStatusBridge(),
			new AdapterStatusBridge(),
			new WebViewErrorHandler(eventSender),
			new ScarAdapterFactory(),
			eventSender
		);
	}

	public static GMA getInstance() {
		return getInstance(new GMAEventSender());
	}

	public static GMA getInstance(GMAEventSender eventSender) {
		if (instance == null) {
			instance = new GMA(eventSender);
		}
		return instance;
	}

	public GMAScarAdapterBridge getBridge() {
		return _gmaScarAdapterBridge;
	}

	/**
	 * Helper function to check if GMA SCAR bidding signals collection is supported.
	 *
	 * @return true if supported, false otherwise
	 */
	public boolean hasSCARBiddingSupport() {
		return _gmaScarAdapterBridge.hasSCARBiddingSupport();
	}

	/**
	 * Helper function for GMAScar bidding signals retrieval.
	 *
	 * @param listener {@link IBiddingSignalsListener} implementation, to be notified when
	 *                 signals are ready.
	 */
	public void getSCARBiddingSignals(boolean isBannerEnabled, IBiddingSignalsListener listener) {
		_gmaScarAdapterBridge.getSCARBiddingSignals(isBannerEnabled, new BiddingSignalsHandler(isBannerEnabled, listener));
	}

	public void getSCARBiddingSignals(List<UnityAdFormat> adFormatList, IBiddingSignalsListener listener) {
		_gmaScarAdapterBridge.getSCARBiddingSignals(adFormatList, new BiddingSignalsHandler(adFormatList.contains(UnityAdFormat.BANNER), listener));
	}
}
