package com.unity3d.ads.core.domain

import com.unity3d.ads.UnityAds
import com.unity3d.services.core.properties.SdkProperties
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch


internal class TriggerInitializeListener(
    private val coroutineDispatcher: CoroutineDispatcher
) {
    fun success() {
        CoroutineScope(coroutineDispatcher).launch {
            SdkProperties.notifyInitializationComplete()
        }
    }

    fun error(unityAdsInitializationError: UnityAds.UnityAdsInitializationError, errorMsg: String) {
        CoroutineScope(coroutineDispatcher).launch {
            SdkProperties.notifyInitializationFailed(unityAdsInitializationError, errorMsg)
        }
    }
}