package com.unity3d.ads.core.data.datasource

import android.content.Context
import androidx.datastore.core.DataStore
import androidx.datastore.core.DataStoreFactory
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler
import com.unity3d.ads.core.data.model.UniversalRequestStoreSerializer
import com.unity3d.ads.core.extensions.unityAdsDataStoreFile
import com.unity3d.ads.datastore.UniversalRequestStoreOuterClass
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_UNIVERSAL_REQUEST
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.SupervisorJob

class UniversalRequestDataStoreProvider(
    val context: Context,
    val dispatcher: CoroutineDispatcher
) {
    private var cachedDataStore: DataStore<UniversalRequestStoreOuterClass.UniversalRequestStore>? = null

    operator fun invoke(): DataStore<UniversalRequestStoreOuterClass.UniversalRequestStore> = synchronized(this) {
        cachedDataStore?.let { return it }

        val dataStore = createDataStore()
        cachedDataStore = dataStore
        return dataStore
    }

    private fun createDataStore() = DataStoreFactory.create(
        serializer = UniversalRequestStoreSerializer(),
        produceFile = { context.unityAdsDataStoreFile(DATA_STORE_UNIVERSAL_REQUEST) },
        corruptionHandler = ReplaceFileCorruptionHandler(
            produceNewData = {
                UniversalRequestStoreSerializer().defaultValue
            }
        ),
        scope = CoroutineScope(dispatcher + SupervisorJob())
    )
}