package com.unity3d.ads.core.data.datasource

import androidx.datastore.core.CorruptionException
import androidx.datastore.core.DataStore
import com.google.protobuf.ByteString
import com.unity3d.ads.datastore.ByteStringStoreOuterClass.ByteStringStore
import com.unity3d.ads.datastore.byteStringStore
import kotlinx.coroutines.flow.catch
import kotlinx.coroutines.flow.first

class AndroidByteStringDataSource(
    private val dataStore: DataStore<ByteStringStore>,
) : ByteStringDataSource {

    override suspend fun get(): ByteStringStore =
        dataStore.data.catch { exception ->
            if (exception is CorruptionException) {
                emit(byteStringStore {
                    data = ByteString.EMPTY
                })
            } else {
                throw exception
            }
        }.first()

    override suspend fun set(data: ByteString) {
        dataStore.updateData { currentData ->
            currentData.toBuilder()
                .setData(data)
                .build()
        }
    }
}