/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import android.os.ConditionVariable;
import com.unity3d.services.ads.token.INativeTokenGenerator;
import com.unity3d.services.ads.token.INativeTokenGeneratorListener;
import com.unity3d.services.core.configuration.PrivacyConfig;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.misc.IObserver;
import java.util.concurrent.ExecutorService;

public class NativeTokenGeneratorWithPrivacyAwait
implements INativeTokenGenerator {
    private final INativeTokenGenerator _nativeTokenGenerator;
    private final ConditionVariable _privacyAwait;
    private final ExecutorService _executorService;
    private final int _privacyAwaitTimeout;

    public NativeTokenGeneratorWithPrivacyAwait(ExecutorService executorService, INativeTokenGenerator nativeTokenGenerator, int privacyAwaitTimeout) {
        this._executorService = executorService;
        this._nativeTokenGenerator = nativeTokenGenerator;
        this._privacyAwait = new ConditionVariable();
        this._privacyAwaitTimeout = privacyAwaitTimeout;
    }

    @Override
    public void generateToken(final INativeTokenGeneratorListener callback2) {
        final IObserver<PrivacyConfig> privacyConfigObserver = new IObserver<PrivacyConfig>(){

            @Override
            public void updated(PrivacyConfig observable) {
                NativeTokenGeneratorWithPrivacyAwait.this._privacyAwait.open();
            }
        };
        PrivacyConfigStorage.getInstance().registerObserver(privacyConfigObserver);
        this._executorService.execute(new Runnable(){

            @Override
            public void run() {
                NativeTokenGeneratorWithPrivacyAwait.this._privacyAwait.block((long)NativeTokenGeneratorWithPrivacyAwait.this._privacyAwaitTimeout);
                PrivacyConfigStorage.getInstance().unregisterObserver(privacyConfigObserver);
                NativeTokenGeneratorWithPrivacyAwait.this._nativeTokenGenerator.generateToken(callback2);
            }
        });
    }
}

