/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import android.text.TextUtils;
import com.unity3d.services.ads.configuration.AdsModuleConfiguration;
import com.unity3d.services.analytics.core.configuration.AnalyticsModuleConfiguration;
import com.unity3d.services.banners.configuration.BannersModuleConfiguration;
import com.unity3d.services.core.configuration.ConfigurationRequestFactory;
import com.unity3d.services.core.configuration.CoreModuleConfiguration;
import com.unity3d.services.core.configuration.ExperimentObjects;
import com.unity3d.services.core.configuration.Experiments;
import com.unity3d.services.core.configuration.ExperimentsBase;
import com.unity3d.services.core.configuration.ExperimentsReader;
import com.unity3d.services.core.configuration.IExperiments;
import com.unity3d.services.core.configuration.IModuleConfiguration;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.network.core.HttpClient;
import com.unity3d.services.core.network.mapper.WebRequestToHttpRequestKt;
import com.unity3d.services.core.network.model.HttpRequest;
import com.unity3d.services.core.network.model.HttpResponse;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.store.core.configuration.StoreModuleConfiguration;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class Configuration {
    private String _webViewUrl;
    private String _webViewHash;
    private String _webViewVersion;
    private String _webViewData;
    private String _sdkVersion;
    private boolean _delayWebViewUpdate;
    private int _resetWebAppTimeout;
    private int _maxRetries;
    private long _retryDelay;
    private double _retryScalingFactor;
    private int _connectedEventThresholdInMs;
    private int _maximumConnectedEvents;
    private long _networkErrorTimeout;
    private int _showTimeout;
    private int _loadTimeout;
    private int _webViewBridgeTimeout;
    private String _metricsUrl;
    private double _metricSampleRate;
    private long _webViewAppCreateTimeout;
    private String _scarBiddingUrl;
    private Boolean _metricsEnabled;
    private String _filteredJsonString;
    private JSONObject _rawJsonData;
    private String _configUrl;
    private String _unifiedAuctionToken;
    private String _sTkn;
    private String _stateId;
    private ExperimentsReader _experimentReader;
    private int _tokenTimeout;
    private int _privacyRequestWaitTimeout;
    private String _src;
    private ConfigurationRequestFactory _configurationRequestFactory;
    private Map<String, IModuleConfiguration> _moduleConfigurations;
    private final Class<?>[] _moduleConfigurationList = new Class[]{CoreModuleConfiguration.class, AdsModuleConfiguration.class, AnalyticsModuleConfiguration.class, BannersModuleConfiguration.class, StoreModuleConfiguration.class};
    private Class[] _webAppApiClassList;

    public Configuration() {
        this._experimentReader = new ExperimentsReader();
        this.setOptionalFields(new JSONObject(), false);
    }

    public Configuration(String configUrl) {
        this(configUrl, new Experiments());
    }

    public Configuration(JSONObject configData) throws MalformedURLException, JSONException {
        this._experimentReader = new ExperimentsReader();
        this.handleConfigurationData(configData, false);
    }

    public Configuration(String configUrl, ExperimentsReader experimentsReader) {
        this(configUrl, experimentsReader.getCurrentlyActiveExperiments());
        this._experimentReader = experimentsReader;
    }

    public Configuration(String configUrl, IExperiments experiments) {
        this();
        this._configUrl = configUrl;
        this._configurationRequestFactory = new ConfigurationRequestFactory(this);
        this._experimentReader.updateLocalExperiments(experiments);
    }

    public String getConfigUrl() {
        return this._configUrl;
    }

    public Class[] getWebAppApiClassList() {
        if (this._webAppApiClassList == null) {
            this.createWebAppApiClassList();
        }
        return this._webAppApiClassList;
    }

    public Class[] getModuleConfigurationList() {
        return this._moduleConfigurationList;
    }

    public String getWebViewUrl() {
        return this._webViewUrl;
    }

    public void setWebViewUrl(String url) {
        this._webViewUrl = url;
    }

    public String getWebViewHash() {
        return this._webViewHash;
    }

    public void setWebViewHash(String hash) {
        this._webViewHash = hash;
    }

    public String getWebViewVersion() {
        return this._webViewVersion;
    }

    public String getWebViewData() {
        return this._webViewData;
    }

    public void setWebViewData(String data) {
        this._webViewData = data;
    }

    public String getSdkVersion() {
        return this._sdkVersion;
    }

    public boolean getDelayWebViewUpdate() {
        return this._delayWebViewUpdate;
    }

    public int getResetWebappTimeout() {
        return this._resetWebAppTimeout;
    }

    public int getMaxRetries() {
        return this._maxRetries;
    }

    public long getRetryDelay() {
        return this._retryDelay;
    }

    public double getRetryScalingFactor() {
        return this._retryScalingFactor;
    }

    public int getConnectedEventThreshold() {
        return this._connectedEventThresholdInMs;
    }

    public int getMaximumConnectedEvents() {
        return this._maximumConnectedEvents;
    }

    public long getNetworkErrorTimeout() {
        return this._networkErrorTimeout;
    }

    public int getShowTimeout() {
        return this._showTimeout;
    }

    public int getLoadTimeout() {
        return this._loadTimeout;
    }

    public int getWebViewBridgeTimeout() {
        return this._webViewBridgeTimeout;
    }

    public String getMetricsUrl() {
        return this._metricsUrl;
    }

    public String getScarBiddingUrl() {
        return this._scarBiddingUrl;
    }

    public double getMetricSampleRate() {
        return this._metricSampleRate;
    }

    public long getWebViewAppCreateTimeout() {
        return this._webViewAppCreateTimeout;
    }

    public String getStateId() {
        return this._stateId != null ? this._stateId : "";
    }

    public String getUnifiedAuctionToken() {
        return this._unifiedAuctionToken;
    }

    public String getSessionToken() {
        return this._sTkn;
    }

    public IExperiments getExperiments() {
        return this._experimentReader.getCurrentlyActiveExperiments();
    }

    public ExperimentsReader getExperimentsReader() {
        return this._experimentReader;
    }

    public int getTokenTimeout() {
        return this._tokenTimeout;
    }

    public int getPrivacyRequestWaitTimeout() {
        return this._privacyRequestWaitTimeout;
    }

    public String getSrc() {
        return this._src != null ? this._src : "";
    }

    public IModuleConfiguration getModuleConfiguration(Class moduleClass) {
        if (this._moduleConfigurations != null && this._moduleConfigurations.containsKey(moduleClass)) {
            return this._moduleConfigurations.get(moduleClass);
        }
        try {
            IModuleConfiguration module = (IModuleConfiguration)moduleClass.newInstance();
            if (module != null) {
                if (this._moduleConfigurations == null) {
                    this._moduleConfigurations = new HashMap<String, IModuleConfiguration>();
                    this._moduleConfigurations.put(moduleClass.getName(), module);
                }
                return module;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFilteredJsonString() {
        return this._filteredJsonString;
    }

    public JSONObject getRawConfigData() {
        return this._rawJsonData;
    }

    public void makeRequest() throws Exception {
        if (this._configUrl == null) {
            throw new MalformedURLException("Base URL is null");
        }
        WebRequest request2 = this._configurationRequestFactory.getWebRequest();
        HttpRequest httpRequest = WebRequestToHttpRequestKt.toHttpRequest(request2);
        InitializeEventsMetricSender.getInstance().didConfigRequestStart();
        HttpClient httpClient2 = (HttpClient)Utilities.getService(HttpClient.class);
        HttpResponse response = httpClient2.executeBlocking(httpRequest);
        String data = response.getBody().toString();
        try {
            this.handleConfigurationData(new JSONObject(data), true);
        }
        catch (Exception e) {
            InitializeEventsMetricSender.getInstance().didConfigRequestEnd(false);
            throw e;
        }
        InitializeEventsMetricSender.getInstance().didConfigRequestEnd(true);
        this.saveToDisk();
    }

    protected void handleConfigurationData(JSONObject configData, boolean isRemoteConfig) throws MalformedURLException, JSONException {
        String url = null;
        try {
            url = !configData.isNull("url") ? configData.getString("url") : null;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (TextUtils.isEmpty(url)) {
            throw new MalformedURLException("WebView URL is null or empty");
        }
        this._webViewUrl = url;
        try {
            this._webViewHash = !configData.isNull("hash") ? configData.getString("hash") : null;
        }
        catch (JSONException e) {
            this._webViewHash = null;
        }
        this._unifiedAuctionToken = !configData.isNull("tkn") ? configData.optString("tkn") : null;
        this._stateId = !configData.isNull("sid") ? configData.optString("sid") : null;
        this._sTkn = !configData.isNull("sTkn") ? configData.optString("sTkn") : null;
        this.setOptionalFields(configData, isRemoteConfig);
        this._filteredJsonString = this.getFilteredConfigJson(configData).toString();
        this._rawJsonData = configData;
    }

    private void setOptionalFields(JSONObject configData, boolean isRemoteConfig) {
        this._webViewVersion = configData.optString("version", null);
        this._delayWebViewUpdate = configData.optBoolean("dwu", false);
        this._resetWebAppTimeout = configData.optInt("rwt", 10000);
        this._maxRetries = configData.optInt("mr", 6);
        this._retryDelay = configData.optLong("rd", 5000L);
        this._retryScalingFactor = configData.optDouble("rcf", 2.0);
        this._connectedEventThresholdInMs = configData.optInt("cet", 10000);
        this._maximumConnectedEvents = configData.optInt("mce", 500);
        this._networkErrorTimeout = configData.optLong("net", 60000L);
        this._sdkVersion = configData.optString("sdkv", "");
        this._showTimeout = configData.optInt("sto", 10000);
        this._loadTimeout = configData.optInt("lto", 30000);
        this._webViewBridgeTimeout = configData.optInt("wto", 5000);
        this._metricsUrl = configData.optString("murl", "");
        this._metricSampleRate = configData.optDouble("msr", 100.0);
        this._webViewAppCreateTimeout = configData.optLong("wct", 60000L);
        this._tokenTimeout = configData.optInt("tto", 5000);
        this._privacyRequestWaitTimeout = configData.optInt("prwto", 3000);
        this._src = configData.optString("src", null);
        this._scarBiddingUrl = configData.optString("scurl", "https://scar.unityads.unity3d.com/v1/capture-scar-signals");
        this._metricsEnabled = this._metricSampleRate >= (double)(new Random().nextInt(99) + 1);
        ExperimentsBase experiments = configData.has("expo") ? new ExperimentObjects(configData.optJSONObject("expo")) : new Experiments(configData.optJSONObject("exp"));
        if (isRemoteConfig) {
            this._experimentReader.updateRemoteExperiments(experiments);
        } else {
            this._experimentReader.updateLocalExperiments(experiments);
        }
    }

    private void createWebAppApiClassList() {
        ArrayList<Class> apiList = new ArrayList<Class>();
        for (Class moduleConfigClass : this.getModuleConfigurationList()) {
            IModuleConfiguration moduleConfiguration = this.getModuleConfiguration(moduleConfigClass);
            if (moduleConfiguration == null || moduleConfiguration.getWebAppApiClassList() == null) continue;
            apiList.addAll(Arrays.asList(moduleConfiguration.getWebAppApiClassList()));
        }
        this._webAppApiClassList = apiList.toArray(new Class[apiList.size()]);
    }

    public void saveToDisk() {
        Utilities.writeFile(new File(SdkProperties.getLocalConfigurationFilepath()), this.getFilteredJsonString());
    }

    public void deleteFromDisk() {
        File file = new File(SdkProperties.getLocalConfigurationFilepath());
        if (file.exists()) {
            file.delete();
        }
    }

    private JSONObject getFilteredConfigJson(JSONObject jsonConfig) throws JSONException {
        JSONObject filteredConfig = new JSONObject();
        Iterator it = jsonConfig.keys();
        while (it.hasNext()) {
            String currentKey = (String)it.next();
            Object currentValue = jsonConfig.opt(currentKey);
            if (currentKey.equalsIgnoreCase("tkn") || currentKey.equalsIgnoreCase("sid") || currentKey.equalsIgnoreCase("srr") || currentKey.equalsIgnoreCase("sTkn")) continue;
            filteredConfig.put(currentKey, currentValue);
        }
        return filteredConfig;
    }

    public Boolean areMetricsEnabledForCurrentSession() {
        return this._metricsEnabled;
    }
}

