package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.core.reflection.GenericBridge

class QueryPurchasesParamsBuilderBridge(var builderInstance: Any): GenericBridge(
    mapOf(
        SET_PRODUCT_TYPE_METHOD to arrayOf(String::class.java),
        BUILD_METHOD to emptyArray()
    )
) {
    override fun getClassName(): String {
        return "com.android.billingclient.api.QueryPurchasesParams\$Builder"
    }

    fun build(): QueryProductDetailsParamsBridge {
        val queryProductDetailsParams = callNonVoidMethod<Any>(BUILD_METHOD, builderInstance)
        return QueryProductDetailsParamsBridge(queryProductDetailsParams)
    }

    fun setProductType(productType: String): QueryPurchasesParamsBuilderBridge {
        builderInstance = callNonVoidMethod(SET_PRODUCT_TYPE_METHOD, builderInstance, productType)
        return this
    }

    companion object {
        private const val BUILD_METHOD = "build"
        private const val SET_PRODUCT_TYPE_METHOD = "setProductType"
    }


}