package com.unity3d.ads.core.log

import android.util.Log

internal class UnityLogger : Logger {

    companion object {
        private const val LOG_TAG = "UnityAds"
    }

    override var logLevel = LogLevel.INFO

    private fun canLog(targetLogLevel: Int) = Log.isLoggable(LOG_TAG, targetLogLevel)
        && targetLogLevel >= logLevel.toAndroidLogLevel()


    override fun info(message: String) {
        if (!canLog(Log.INFO)) return
        Log.i(LOG_TAG, message)
    }

    override fun debug(message: String) {
        if (!canLog(Log.DEBUG)) return
        Log.d(LOG_TAG, message)
    }

    override fun error(message: String, e: Throwable?) {
        if (!canLog(Log.ERROR)) return
        Log.e(LOG_TAG, message, e)
    }

    override fun trace(message: String, e: Throwable?) {
        if (!canLog(Log.VERBOSE)) return
        Log.v(LOG_TAG, message, e)
    }
}