package com.unity3d.ads.core.domain.events

import com.unity3d.ads.core.domain.GetByteStringId
import com.unity3d.ads.core.extensions.fromMillis
import com.unity3d.ads.core.extensions.fromPurchaseState
import com.unity3d.services.store.gpbl.bridges.PurchaseBridge
import gatewayprotocol.v1.TransactionEventRequestOuterClass.TransactionData
import gatewayprotocol.v1.transactionData



internal class AndroidGetTransactionData(
    private val getByteStringId: GetByteStringId,
) : GetTransactionData {
    override operator fun invoke(purchaseDetail: PurchaseBridge, productDetailJson: String): TransactionData {
        return transactionData {
            productId = purchaseDetail.originalJson["productId"].toString()
            eventId = getByteStringId()
            timestamp = fromMillis(purchaseDetail.originalJson["purchaseTime"] as Long)
            transactionId = purchaseDetail.originalJson["orderId"].toString()
            product = productDetailJson
            transaction = purchaseDetail.originalJson.toString()
            signature = purchaseDetail.signature
            transactionState = fromPurchaseState(purchaseDetail.originalJson["purchaseState"] as Int)
        }
    }
}