package com.unity3d.services.store.gpbl.proxies

import com.unity3d.services.core.reflection.GenericListenerProxy
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge
import com.unity3d.services.store.gpbl.bridges.billingclient.v8.QueryProductDetailsResultsBridge
import com.unity3d.services.store.gpbl.listeners.ProductDetailsResponseListener
import java.lang.reflect.Method

class ProductDetailsResponseListenerProxy(val productDetailsResponseListener: ProductDetailsResponseListener?) : GenericListenerProxy() {
    override fun getProxyClass(): Class<*> {
        return getProxyListenerClass()
    }

    override fun invoke(proxy: Any, method: Method, args: Array<Any>?): Any? {
        var result: Any? = null
        if (method.name == onProductDetailsResponseMethodName) {
            args?.get(1)?.let { onPurchasesUpdated(args[0], it) }
		} else {
            result = super.invoke(proxy, method, args)
		}
        return result
	}

	// Wraps onProductDetailsResponse (BillingResult billingResult, QueryProductDetailsResultsBridge productDetailsResults)
    private fun onPurchasesUpdated(billingResult: Any?, productDetailsResult: Any) {
        val productDetailsBridge = QueryProductDetailsResultsBridge(productDetailsResult)
        productDetailsResponseListener?.onProductDetailsResponse(BillingResultBridge(billingResult), productDetailsBridge)
	}

    companion object {
        const val onProductDetailsResponseMethodName: String = "onProductDetailsResponse"

        @Throws(ClassNotFoundException::class)
        fun getProxyListenerClass(): Class<*> {
            return Class.forName("com.android.billingclient.api.ProductDetailsResponseListener")
        }
    }

}