/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.IWebRequestListener;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.core.request.WebRequestError;
import com.unity3d.services.core.request.WebRequestEvent;
import com.unity3d.services.core.request.WebRequestThread;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class Request {
    @WebViewExposed
    public static void get(final String id, String url, JSONArray headers, Integer connectTimeout, Integer readTimeout, WebViewCallback callback2) {
        HashMap<String, List<String>> mappedHeaders;
        if (headers != null && headers.length() == 0) {
            headers = null;
        }
        try {
            mappedHeaders = Request.getHeadersMap(headers);
        }
        catch (Exception e) {
            DeviceLog.exception("Error mapping headers for the request", e);
            callback2.error(WebRequestError.MAPPING_HEADERS_FAILED, id);
            return;
        }
        WebRequestThread.request(url, WebRequest.RequestType.GET, mappedHeaders, null, connectTimeout, readTimeout, new IWebRequestListener(){

            @Override
            public void onComplete(String url, String response, int responseCode, Map<String, List<String>> responseHeaders) {
                JSONArray headers;
                try {
                    headers = Request.getResponseHeadersMap(responseHeaders);
                }
                catch (Exception e) {
                    DeviceLog.exception("Error parsing response headers", e);
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.FAILED, id, url, "Error parsing response headers");
                    return;
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.COMPLETE, id, url, response, responseCode, headers);
            }

            @Override
            public void onFailed(String url, String error2) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.FAILED, id, url, error2);
            }
        });
        callback2.invoke(id);
    }

    @WebViewExposed
    public static void post(final String id, String url, String requestBody, JSONArray headers, Integer connectTimeout, Integer readTimeout, WebViewCallback callback2) {
        HashMap<String, List<String>> mappedHeaders;
        if (requestBody != null && requestBody.length() == 0) {
            requestBody = null;
        }
        if (headers != null && headers.length() == 0) {
            headers = null;
        }
        try {
            mappedHeaders = Request.getHeadersMap(headers);
        }
        catch (Exception e) {
            DeviceLog.exception("Error mapping headers for the request", e);
            callback2.error(WebRequestError.MAPPING_HEADERS_FAILED, id);
            return;
        }
        WebRequestThread.request(url, WebRequest.RequestType.POST, mappedHeaders, requestBody, connectTimeout, readTimeout, new IWebRequestListener(){

            @Override
            public void onComplete(String url, String response, int responseCode, Map<String, List<String>> responseHeaders) {
                JSONArray headers;
                try {
                    headers = Request.getResponseHeadersMap(responseHeaders);
                }
                catch (Exception e) {
                    DeviceLog.exception("Error parsing response headers", e);
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.FAILED, id, url, "Error parsing response headers");
                    return;
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.COMPLETE, id, url, response, responseCode, headers);
            }

            @Override
            public void onFailed(String url, String error2) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.FAILED, id, url, error2);
            }
        });
        callback2.invoke(id);
    }

    @WebViewExposed
    public static void head(final String id, String url, JSONArray headers, Integer connectTimeout, Integer readTimeout, WebViewCallback callback2) {
        HashMap<String, List<String>> mappedHeaders;
        if (headers != null && headers.length() == 0) {
            headers = null;
        }
        try {
            mappedHeaders = Request.getHeadersMap(headers);
        }
        catch (Exception e) {
            DeviceLog.exception("Error mapping headers for the request", e);
            callback2.error(WebRequestError.MAPPING_HEADERS_FAILED, id);
            return;
        }
        WebRequestThread.request(url, WebRequest.RequestType.HEAD, mappedHeaders, connectTimeout, readTimeout, new IWebRequestListener(){

            @Override
            public void onComplete(String url, String response, int responseCode, Map<String, List<String>> responseHeaders) {
                JSONArray headers;
                try {
                    headers = Request.getResponseHeadersMap(responseHeaders);
                }
                catch (Exception e) {
                    DeviceLog.exception("Error parsing response headers", e);
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.FAILED, id, url, "Error parsing response headers");
                    return;
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.COMPLETE, id, url, response, responseCode, headers);
            }

            @Override
            public void onFailed(String url, String error2) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.REQUEST, WebRequestEvent.FAILED, id, url, error2);
            }
        });
        callback2.invoke(id);
    }

    @WebViewExposed
    public static void setConcurrentRequestCount(Integer count, WebViewCallback callback2) {
        WebRequestThread.setConcurrentRequestCount(count);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void setMaximumPoolSize(Integer count, WebViewCallback callback2) {
        WebRequestThread.setMaximumPoolSize(count);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void setKeepAliveTime(Integer milliseconds, WebViewCallback callback2) {
        WebRequestThread.setKeepAliveTime(milliseconds.longValue());
        callback2.invoke(new Object[0]);
    }

    public static JSONArray getResponseHeadersMap(Map<String, List<String>> responseHeaders) {
        JSONArray retObj = new JSONArray();
        if (responseHeaders != null && responseHeaders.size() > 0) {
            for (String key : responseHeaders.keySet()) {
                JSONArray keyValueMap = null;
                for (String value : responseHeaders.get(key)) {
                    keyValueMap = new JSONArray();
                    keyValueMap.put((Object)key);
                    keyValueMap.put((Object)value);
                }
                retObj.put(keyValueMap);
            }
        }
        return retObj;
    }

    public static HashMap<String, List<String>> getHeadersMap(JSONArray headers) throws JSONException {
        HashMap<String, ArrayList<String>> mappedHeaders = null;
        if (headers != null) {
            mappedHeaders = new HashMap<String, ArrayList<String>>();
            for (int idx = 0; idx < headers.length(); ++idx) {
                JSONArray header = (JSONArray)headers.get(idx);
                ArrayList<String> valueList = (ArrayList<String>)mappedHeaders.get(header.getString(0));
                if (valueList == null) {
                    valueList = new ArrayList<String>();
                }
                valueList.add(header.getString(1));
                mappedHeaders.put(header.getString(0), valueList);
            }
        }
        return mappedHeaders;
    }
}

