/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import android.util.SparseArray;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.DeviceInfoEvent;
import com.unity3d.services.core.device.VolumeChange;
import com.unity3d.services.core.device.VolumeChangeListener;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.IEventSender;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unity3d/services/core/device/VolumeChangeMonitor;", "", "eventSender", "Lcom/unity3d/services/core/webview/bridge/IEventSender;", "volumeChange", "Lcom/unity3d/services/core/device/VolumeChange;", "(Lcom/unity3d/services/core/webview/bridge/IEventSender;Lcom/unity3d/services/core/device/VolumeChange;)V", "volumeChangeListeners", "Landroid/util/SparseArray;", "Lcom/unity3d/services/core/device/VolumeChangeListener;", "registerVolumeChangeListener", "", "streamType", "", "unregisterVolumeChangeListener", "unity-ads_release"})
public final class VolumeChangeMonitor {
    @NotNull
    private final IEventSender eventSender;
    @NotNull
    private final VolumeChange volumeChange;
    @NotNull
    private final SparseArray<VolumeChangeListener> volumeChangeListeners;

    public VolumeChangeMonitor(@NotNull IEventSender eventSender, @NotNull VolumeChange volumeChange) {
        Intrinsics.checkNotNullParameter((Object)eventSender, (String)"eventSender");
        Intrinsics.checkNotNullParameter((Object)volumeChange, (String)"volumeChange");
        this.eventSender = eventSender;
        this.volumeChange = volumeChange;
        this.volumeChangeListeners = new SparseArray();
    }

    public final void registerVolumeChangeListener(int streamType) {
        if (this.volumeChangeListeners.get(streamType) == null) {
            VolumeChangeListener listener2 = new VolumeChangeListener(this, streamType){
                final /* synthetic */ VolumeChangeMonitor this$0;
                final /* synthetic */ int $streamType;
                {
                    this.this$0 = $receiver;
                    this.$streamType = $streamType;
                }

                public void onVolumeChanged(int volume) {
                    Object[] objectArray = new Object[]{this.getStreamType(), volume, Device.getStreamMaxVolume(this.$streamType)};
                    VolumeChangeMonitor.access$getEventSender$p(this.this$0).sendEvent(WebViewEventCategory.DEVICEINFO, DeviceInfoEvent.VOLUME_CHANGED, objectArray);
                }

                public int getStreamType() {
                    return this.$streamType;
                }
            };
            this.volumeChangeListeners.append(streamType, (Object)listener2);
            this.volumeChange.registerListener(listener2);
        }
    }

    public final void unregisterVolumeChangeListener(int streamType) {
        if (this.volumeChangeListeners.get(streamType) != null) {
            VolumeChangeListener listener2 = (VolumeChangeListener)this.volumeChangeListeners.get(streamType);
            Intrinsics.checkNotNullExpressionValue((Object)listener2, (String)"listener");
            this.volumeChange.unregisterListener(listener2);
            this.volumeChangeListeners.remove(streamType);
        }
    }

    public static final /* synthetic */ IEventSender access$getEventSender$p(VolumeChangeMonitor $this) {
        return $this.eventSender;
    }
}

