/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.ads.gmascar.managers.ScarBiddingManagerType;
import com.unity3d.services.core.configuration.ExperimentsBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class Experiments
extends ExperimentsBase {
    private static final Set<String> NEXT_SESSION_FLAGS = new HashSet<String>(Collections.singletonList("tsi_prw"));
    private final JSONObject _experimentData;

    public Experiments() {
        this(null);
    }

    public Experiments(JSONObject experimentData) {
        this._experimentData = experimentData == null ? new JSONObject() : experimentData;
    }

    @Override
    public boolean shouldNativeTokenAwaitPrivacy() {
        return this._experimentData.optBoolean("tsi_prw", false);
    }

    @Override
    public boolean isWebAssetAdCaching() {
        return this._experimentData.optBoolean("wac", false);
    }

    @Override
    public boolean isWebGestureNotRequired() {
        return this._experimentData.optBoolean("wgr", false);
    }

    @Override
    public boolean isScarInitEnabled() {
        return this._experimentData.optBoolean("scar_init", false);
    }

    @Override
    public boolean isScarBannerHbEnabled() {
        return this._experimentData.optBoolean("scar_bn", false);
    }

    @Override
    public String getScarBiddingManager() {
        return this._experimentData.optString("scar_bm", ScarBiddingManagerType.DISABLED.getName());
    }

    @Override
    public boolean isJetpackLifecycle() {
        return this._experimentData.optBoolean("gjl", false);
    }

    @Override
    public boolean isOkHttpEnabled() {
        return this._experimentData.optBoolean("okhttp", false);
    }

    @Override
    public boolean isWebMessageEnabled() {
        return this._experimentData.optBoolean("jwm", false);
    }

    @Override
    public boolean isWebViewAsyncDownloadEnabled() {
        return this._experimentData.optBoolean("wad", false);
    }

    @Override
    public boolean isNativeShowTimeoutDisabled() {
        return this._experimentData.optBoolean("nstd", false);
    }

    @Override
    public boolean isNativeLoadTimeoutDisabled() {
        return this._experimentData.optBoolean("nltd", false);
    }

    @Override
    public boolean isCaptureHDRCapabilitiesEnabled() {
        return this._experimentData.optBoolean("hdrc", false);
    }

    @Override
    public boolean isPCCheckEnabled() {
        return this._experimentData.optBoolean("pc_check", false);
    }

    @Override
    public boolean isBoldSdkNextSessionEnabled() {
        return this._experimentData.optBoolean("boldSdkNextSessionEnabled", false);
    }

    @Override
    public JSONObject getExperimentsAsJson() {
        return this._experimentData;
    }

    @Override
    public Map<String, String> getExperimentTags() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        Iterator keyItor = this._experimentData.keys();
        while (keyItor.hasNext()) {
            String key = (String)keyItor.next();
            map2.put(key, String.valueOf(this._experimentData.opt(key)));
        }
        return map2;
    }

    @Override
    public JSONObject getNextSessionExperiments() {
        if (this._experimentData == null) {
            return null;
        }
        HashMap<String, String> nextSessionFlags = new HashMap<String, String>();
        Iterator it = this._experimentData.keys();
        while (it.hasNext()) {
            String currentKey = (String)it.next();
            if (!NEXT_SESSION_FLAGS.contains(currentKey)) continue;
            nextSessionFlags.put(currentKey, String.valueOf(this._experimentData.optBoolean(currentKey)));
        }
        return new JSONObject(nextSessionFlags);
    }

    @Override
    public JSONObject getCurrentSessionExperiments() {
        if (this._experimentData == null) {
            return null;
        }
        HashMap<String, String> currentSessionFlags = new HashMap<String, String>();
        Iterator it = this._experimentData.keys();
        while (it.hasNext()) {
            String currentKey = (String)it.next();
            if (NEXT_SESSION_FLAGS.contains(currentKey)) continue;
            currentSessionFlags.put(currentKey, String.valueOf(this._experimentData.optBoolean(currentKey)));
        }
        return new JSONObject(currentSessionFlags);
    }
}

