/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import com.unity3d.services.ads.token.AsyncTokenStorage;
import com.unity3d.services.ads.token.NativeTokenGenerator;
import com.unity3d.services.ads.token.TokenEvent;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.reader.GameSessionIdReader;
import com.unity3d.services.core.device.reader.builder.DeviceInfoReaderBuilder;
import com.unity3d.services.core.di.IServiceComponent;
import com.unity3d.services.core.di.IServiceProvider;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\u0012\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/unity3d/services/ads/token/InMemoryTokenStorage;", "Lcom/unity3d/services/ads/token/TokenStorage;", "Lcom/unity3d/services/core/di/IServiceComponent;", "()V", "accessCounter", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "asyncTokenStorage", "Lcom/unity3d/services/ads/token/AsyncTokenStorage;", "getAsyncTokenStorage", "()Lcom/unity3d/services/ads/token/AsyncTokenStorage;", "asyncTokenStorage$delegate", "Lkotlin/Lazy;", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "initToken", "", "nativeGeneratedToken", "", "getNativeGeneratedToken", "()Lkotlin/Unit;", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "token", "getToken", "()Ljava/lang/String;", "appendTokens", "tokens", "Lorg/json/JSONArray;", "createTokens", "deleteTokens", "setInitToken", "value", "triggerTokenAvailable", "withConfig", "", "unity-ads_release"})
@SourceDebugExtension(value={"SMAP\nInMemoryTokenStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryTokenStorage.kt\ncom/unity3d/services/ads/token/InMemoryTokenStorage\n+ 2 IServiceComponent.kt\ncom/unity3d/services/core/di/IServiceComponentKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,101:1\n29#2,5:102\n230#3,5:107\n214#3,5:112\n230#3,5:117\n*S KotlinDebug\n*F\n+ 1 InMemoryTokenStorage.kt\ncom/unity3d/services/ads/token/InMemoryTokenStorage\n*L\n27#1:102,5\n53#1:107,5\n67#1:112,5\n91#1:117,5\n*E\n"})
public final class InMemoryTokenStorage
implements TokenStorage,
IServiceComponent {
    @NotNull
    private final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue();
    @NotNull
    private final MutableStateFlow<Integer> accessCounter = StateFlowKt.MutableStateFlow((Object)-1);
    @NotNull
    private final MutableStateFlow<String> initToken = StateFlowKt.MutableStateFlow(null);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    @NotNull
    private final Lazy asyncTokenStorage$delegate;

    public InMemoryTokenStorage() {
        IServiceComponent $this$inject_u24default$iv = this;
        String named$iv = "";
        LazyThreadSafetyMode mode$iv = LazyThreadSafetyMode.NONE;
        boolean $i$f$inject = false;
        this.asyncTokenStorage$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<AsyncTokenStorage>($this$inject_u24default$iv, named$iv){
            final /* synthetic */ IServiceComponent $this_inject;
            final /* synthetic */ String $named;
            {
                this.$this_inject = $receiver;
                this.$named = $named;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AsyncTokenStorage invoke() {
                void $this$get$iv;
                IServiceComponent iServiceComponent = this.$this_inject;
                String named$iv = this.$named;
                boolean $i$f$get = false;
                return $this$get$iv.getServiceProvider().getRegistry().getService(named$iv, Reflection.getOrCreateKotlinClass(AsyncTokenStorage.class));
            }
        }));
    }

    private final AsyncTokenStorage getAsyncTokenStorage() {
        Lazy lazy = this.asyncTokenStorage$delegate;
        return (AsyncTokenStorage)lazy.getValue();
    }

    @Override
    public void createTokens(@NotNull JSONArray tokens) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.deleteTokens();
        this.appendTokens(tokens);
    }

    @Override
    public void appendTokens(@NotNull JSONArray tokens) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.accessCounter.compareAndSet((Object)-1, (Object)0);
        int tokenLength = tokens.length();
        for (int i = 0; i < tokenLength; ++i) {
            this.queue.add(tokens.getString(i));
        }
        if (tokenLength > 0) {
            this.triggerTokenAvailable(false);
            this.getAsyncTokenStorage().onTokenAvailable();
        }
    }

    @Override
    public void deleteTokens() {
        Integer nextValue$iv;
        Object prevValue$iv;
        this.queue.clear();
        MutableStateFlow<Integer> $this$update$iv = this.accessCounter;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            int it = ((Number)prevValue$iv).intValue();
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Integer.valueOf(-1))));
    }

    @Override
    @Nullable
    public String getToken() {
        int it;
        Integer nextValue$iv;
        Object prevValue$iv;
        if (((Number)this.accessCounter.getValue()).intValue() == -1) {
            return (String)this.initToken.getValue();
        }
        if (this.queue.isEmpty()) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.QUEUE_EMPTY, new Object[0]);
            return null;
        }
        MutableStateFlow<Integer> $this$getAndUpdate$iv = this.accessCounter;
        boolean $i$f$getAndUpdate = false;
        do {
            prevValue$iv = $this$getAndUpdate$iv.getValue();
            it = ((Number)prevValue$iv).intValue();
            boolean bl = false;
        } while (!$this$getAndUpdate$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Integer.valueOf(it + 1))));
        int accesses = ((Number)prevValue$iv).intValue();
        Object[] objectArray = new Object[]{accesses};
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, objectArray);
        return this.queue.poll();
    }

    @Override
    @NotNull
    public Unit getNativeGeneratedToken() {
        NativeTokenGenerator nativeTokenGenerator = new NativeTokenGenerator(this.executorService, new DeviceInfoReaderBuilder(new ConfigurationReader(), PrivacyConfigStorage.getInstance(), GameSessionIdReader.getInstance()), null);
        nativeTokenGenerator.generateToken(InMemoryTokenStorage::_get_nativeGeneratedToken_$lambda$2);
        return Unit.INSTANCE;
    }

    @Override
    public void setInitToken(@Nullable String value) {
        String nextValue$iv;
        Object prevValue$iv;
        if (value == null) {
            return;
        }
        MutableStateFlow<String> $this$update$iv = this.initToken;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            String it = (String)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = value)));
        this.triggerTokenAvailable(true);
        this.getAsyncTokenStorage().onTokenAvailable();
    }

    private final void triggerTokenAvailable(boolean withConfig) {
        InitializeEventsMetricSender.getInstance().sdkTokenDidBecomeAvailableWithConfig(withConfig);
    }

    @Override
    @NotNull
    public IServiceProvider getServiceProvider() {
        return IServiceComponent.DefaultImpls.getServiceProvider(this);
    }

    private static final void _get_nativeGeneratedToken_$lambda$2(String token2) {
        Object[] objectArray = new Object[]{token2};
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_NATIVE_DATA, objectArray);
    }
}

