package com.unity3d.ads.core.data.datasource

import com.unity3d.ads.core.domain.privacy.FlattenerRulesUseCase
import com.unity3d.services.core.misc.JsonFlattener
import com.unity3d.services.core.misc.JsonStorage

class AndroidLegacyUserConsentDataSource(
    private val flattenerRulesUseCase: FlattenerRulesUseCase,
    private val privateStorage: JsonStorage,
) : LegacyUserConsentDataSource {
    override val privacyData: String?
        get(): String? {
            privateStorage.data?.let {
                val flattener = JsonFlattener(it)
                return flattener.flattenJson(".", flattenerRulesUseCase())?.toString()
            }?: return null
        }
}