package com.unity3d.ads.core.domain.scar

import com.google.protobuf.ByteString
import com.google.protobuf.kotlin.toByteStringUtf8
import com.unity3d.services.ads.gmascar.models.BiddingSignals
import gatewayprotocol.v1.GetTokenEventRequestOuterClass.GetTokenEventRequest
import gatewayprotocol.v1.getTokenEventRequest

class GetAndroidTokenEventRequest : GetHbTokenEventRequest {
    override suspend operator fun invoke(
        tokenId: ByteString,
        biddingSignals: BiddingSignals
    ): GetTokenEventRequest {
        return getTokenEventRequest {
            this.tokenId = tokenId
            biddingSignals.rvSignal?.let {
                rewarded = it.toByteStringUtf8()
            }
            biddingSignals.interstitialSignal?.let {
                interstitial = it.toByteStringUtf8()
            }
            biddingSignals.bannerSignal?.let {
                banner = it.toByteStringUtf8()
            }
        }
    }
}