package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.OperationType
import com.unity3d.ads.gatewayclient.GatewayClient
import com.unity3d.services.core.di.ServiceProvider.DEFAULT_DISPATCHER
import com.unity3d.services.core.di.ServiceProvider.NAMED_AD_REQ
import gatewayprotocol.v1.AdDataRefreshResponseOuterClass.AdDataRefreshResponse
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.withContext




internal class AndroidRefresh(
    private val defaultDispatcher: CoroutineDispatcher,
    private val getAdDataRefreshRequest: GetAdDataRefreshRequest,
    private val getRequestPolicy: GetRequestPolicy,
    private val gatewayClient: GatewayClient,
) : Refresh {
    override suspend fun invoke(
        opportunityId: ByteString,
        adDataRefreshToken: ByteString
    ): AdDataRefreshResponse =
        withContext(defaultDispatcher) {
                val refreshRequest = getAdDataRefreshRequest(adDataRefreshToken, opportunityId)
                val requestPolicy = getRequestPolicy()
                val gatewayAdResponse = gatewayClient.request(request = refreshRequest, requestPolicy = requestPolicy, operationType = OperationType.REFRESH)
                gatewayAdResponse.payload.adDataRefreshResponse
        }
}