package com.unity3d.ads.core.data.datasource

import android.content.Context
import android.content.pm.PackageManager
import android.content.pm.PackageManager.NameNotFoundException
import android.os.Build

internal class AndroidStoreDataSource(
    private val context: Context
) : StoreDataSource {

    @Suppress("DEPRECATION")
    override fun fetchStores(additionalStores: List<String>): List<String> {
        val queriedStores = (AndroidKnownStore.values().map { it.packageName } + additionalStores).distinct()
        val packageManager = context.packageManager
        return queriedStores.filter { storePackageName ->
            try {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                    packageManager.getPackageInfo(
                        storePackageName,
                        PackageManager.PackageInfoFlags.of(0)
                    )
                } else {
                    packageManager.getPackageInfo(storePackageName, 0)
                } != null
            } catch (_: NameNotFoundException) {
                false
            }
        }
    }

}