package com.unity3d.ads.core.data.repository

import com.unity3d.services.UnityAdsConstants
import gatewayprotocol.v1.TransactionEventRequestOuterClass
import kotlinx.coroutines.channels.BufferOverflow
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.asSharedFlow



class AndroidTransactionEventRepository : TransactionEventRepository {
    private val _transactionEvents = MutableSharedFlow<TransactionEventRequestOuterClass.TransactionEventRequest>(
        replay = UnityAdsConstants.SharedFlow.REPLAY,
        extraBufferCapacity = UnityAdsConstants.SharedFlow.EXTRA_CAPACITY,
        onBufferOverflow = BufferOverflow.DROP_OLDEST
    )
    override val transactionEvents = _transactionEvents.asSharedFlow()

    override fun addTransactionEvent(transactionEventRequest: TransactionEventRequestOuterClass.TransactionEventRequest) {
        _transactionEvents.tryEmit(transactionEventRequest)
    }
}