/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview.bridge;

import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.INativeCallbackSubject;
import com.unity3d.services.core.webview.bridge.SharedInstances;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class NativeCallback {
    private static AtomicInteger _callbackCount = new AtomicInteger(0);
    private Method _callback;
    private String _id;
    private final INativeCallbackSubject _nativeCallbackSubject;

    public NativeCallback(Method callback2) {
        this(callback2, SharedInstances.INSTANCE.getWebViewAppNativeCallbackSubject());
    }

    public NativeCallback(Method callback2, INativeCallbackSubject nativeCallbackSubject) {
        this._callback = callback2;
        this._id = this._callback.getName().toUpperCase(Locale.US) + "_" + _callbackCount.getAndIncrement();
        this._nativeCallbackSubject = nativeCallbackSubject;
    }

    public String getId() {
        return this._id;
    }

    public void invoke(String status, Object ... values) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        CallbackStatus cbs;
        try {
            cbs = CallbackStatus.valueOf(status);
        }
        catch (Exception e) {
            DeviceLog.error("Illegal status");
            this._nativeCallbackSubject.remove(this);
            throw e;
        }
        if (values == null) {
            values = new Object[]{cbs};
        } else {
            ArrayList<Object> tmpAr = new ArrayList<Object>(Arrays.asList(values));
            tmpAr.add(0, (Object)cbs);
            values = tmpAr.toArray();
        }
        this._callback.invoke(null, values);
        this._nativeCallbackSubject.remove(this);
    }
}

