package com.unity3d.ads.core.domain.events

import com.unity3d.ads.core.domain.GetByteStringId
import com.unity3d.ads.core.extensions.fromMillis
import com.unity3d.ads.core.extensions.fromPurchaseState
import com.unity3d.services.store.gpbl.bridges.PurchaseBridge
import com.unity3d.services.store.gpbl.bridges.SkuDetailsBridge
import gatewayprotocol.v1.TransactionEventRequestOuterClass.TransactionData
import gatewayprotocol.v1.transactionData



internal class AndroidGetTransactionData(
    private val getByteStringId: GetByteStringId,
) : GetTransactionData {
    override operator fun invoke(purchaseDetail: PurchaseBridge, productDetail: SkuDetailsBridge): TransactionData {
        return transactionData {
            productId = purchaseDetail.originalJson["productId"].toString()
            eventId = getByteStringId()
            timestamp = fromMillis(purchaseDetail.originalJson["purchaseTime"] as Long)
            transactionId = purchaseDetail.originalJson["orderId"].toString()
            product = productDetail.originalJson.toString()
            transaction = purchaseDetail.originalJson.toString()
            transactionState = fromPurchaseState(purchaseDetail.originalJson["purchaseState"] as Int)
        }
    }
}