package com.unity3d.ads.core.configuration

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.core.configuration.ConfigurationReader
import kotlinx.coroutines.flow.MutableStateFlow

class AlternativeFlowReader(
    private val configurationReader: ConfigurationReader,
    private val sessionRepository: SessionRepository
) {
    private val isAlternativeFlowRead = MutableStateFlow(false)
    private val isAlternativeFlowEnabled = MutableStateFlow(false)

    operator fun invoke(): Boolean {
        if (!isAlternativeFlowRead.value) {
            isAlternativeFlowEnabled.value =
                configurationReader.currentConfiguration.experiments.isBoldSdkNextSessionEnabled ||
                    sessionRepository.nativeConfiguration.featureFlags.boldSdkNextSessionEnabled
            isAlternativeFlowRead.value = true
        }
        return isAlternativeFlowEnabled.value
    }
}