package com.unity3d.services.core.configuration

import android.app.Application
import android.content.Context
import androidx.startup.Initializer
import com.unity3d.services.core.properties.ClientProperties
import com.unity3d.services.core.properties.SdkProperties
/**
 * Unity SDK Initializer implementation of Androidx.Startup - Initializer interface.
 */
class AdsSdkInitializer : Initializer<Unit> {
    override fun create(context: Context) {
        ClientProperties.setApplicationContext(context.applicationContext)
        if (context is Application) {
            ClientProperties.setApplication(context)
        } else if (context.applicationContext is Application) {
            val applicationContext = context.applicationContext as Application
            ClientProperties.setApplication(applicationContext)
        }
        SdkProperties.setAppInitializationTimeSinceEpoch(System.currentTimeMillis())
    }

    override fun dependencies(): List<Class<out Initializer<*>>> {
        // No dependencies on other libraries.
        return emptyList()
    }
}