package com.unity3d.services.ads.gmascar.handlers;

import com.unity3d.scar.adapter.common.IScarBannerAdListenerWrapper;
import com.unity3d.services.banners.BannerViewCache;
import com.unity3d.services.banners.bridge.BannerBridge;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.IEventSender;

public class ScarBannerAdHandler implements IScarBannerAdListenerWrapper {

	private final String _operationId;

	private final IEventSender _eventSender;

	public ScarBannerAdHandler(
		IEventSender eventSender,
		String operationId)
	{
		_eventSender = eventSender;
		_operationId = operationId;
	}

	@Override
	public void onAdLoaded() {
		BannerViewCache.getInstance().addScarContainer(_operationId);
		_eventSender.sendEvent(WebViewEventCategory.BANNER, BannerBridge.BannerEvent.SCAR_BANNER_LOADED, _operationId);
	}

	@Override
	public void onAdFailedToLoad(int errorCode, String errorString) {
		_eventSender.sendEvent(WebViewEventCategory.BANNER, BannerBridge.BannerEvent.SCAR_BANNER_LOAD_FAILED, _operationId, errorCode, errorString);
	}

	@Override
	public void onAdOpened() {
		_eventSender.sendEvent(WebViewEventCategory.BANNER, BannerBridge.BannerEvent.SCAR_BANNER_OPENED, _operationId);
	}

	@Override
	public void onAdClicked() {
		_eventSender.sendEvent(WebViewEventCategory.BANNER, BannerBridge.BannerEvent.SCAR_BANNER_CLICKED, _operationId);
	}

	@Override
	public void onAdClosed() {
		// Code to be executed when the user is about to return to the app after tapping on an ad.
		_eventSender.sendEvent(WebViewEventCategory.BANNER, BannerBridge.BannerEvent.SCAR_BANNER_CLOSED, _operationId);
	}

	@Override
	public void onAdImpression() {
		_eventSender.sendEvent(WebViewEventCategory.BANNER, BannerBridge.BannerEvent.SCAR_BANNER_IMPRESSION, _operationId);
	}
}
