package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import gatewayprotocol.v1.UniversalRequestKt.payload
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest
import gatewayprotocol.v1.privacyUpdateRequest



class GetPrivacyUpdateRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad
) {
    suspend operator fun invoke(
        privacyUpdateVersion: Int,
        privacyUpdateContent: ByteString
    ): UniversalRequest {
        val request = privacyUpdateRequest {
            version = privacyUpdateVersion
            content = privacyUpdateContent
        }

        val privacyPayLoad = payload {
            privacyUpdateRequest = request
        }

        return getUniversalRequestForPayLoad(privacyPayLoad)
    }
}