package com.unity3d.ads.core.data.datasource

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.manager.LegacyStorageType
import com.unity3d.ads.core.data.manager.StorageManager
import com.unity3d.ads.core.extensions.fromBase64
import com.unity3d.ads.core.extensions.toBase64
import com.unity3d.ads.datastore.ByteStringStoreOuterClass
import com.unity3d.ads.datastore.byteStringStore

class AndroidLegacyConfigStoreDataSource(
    private val storageManager: StorageManager,
): ByteStringDataSource {
    override suspend fun get(): ByteStringStoreOuterClass.ByteStringStore {
        storageManager.getStorage(LegacyStorageType.PRIVATE).run {
            val str = get(KEY_CONFIGURATION_STORE) as? String

            // IMPORTANT COMMENT
            // https://issuetracker.google.com/issues/141497577?pli=1
            //
            // This will only throw an error if the padding is incorrect (=).
            val dataContent = runCatching {
                str?.fromBase64(true)
            }.getOrNull()

            return byteStringStore {
                data = dataContent ?: ByteString.EMPTY
            }
        }
    }

    override suspend fun set(data: ByteString) {
        storageManager.getStorage(LegacyStorageType.PRIVATE).run {
            set(KEY_CONFIGURATION_STORE, data.toBase64(true))
            writeStorage()
        }
    }

    companion object {
        const val KEY_CONFIGURATION_STORE = "configuration.store"
    }
}