/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.domain;

import com.unity3d.ads.UnityAds;
import com.unity3d.ads.core.configuration.AlternativeFlowReader;
import com.unity3d.ads.core.data.model.InitializationState;
import com.unity3d.ads.core.domain.CheckForGameIdAndTestModeChanges;
import com.unity3d.ads.core.domain.GetInitializationState;
import com.unity3d.ads.core.domain.SetInitializationState;
import com.unity3d.ads.core.domain.ShouldAllowInitialization;
import com.unity3d.ads.core.domain.ValidateGameId;
import com.unity3d.services.core.configuration.EnvironmentCheck;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.metrics.InitMetric;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/unity3d/ads/core/domain/CommonShouldAllowInitialization;", "Lcom/unity3d/ads/core/domain/ShouldAllowInitialization;", "alternativeFlowReader", "Lcom/unity3d/ads/core/configuration/AlternativeFlowReader;", "checkForGameIdAndTestModeChanges", "Lcom/unity3d/ads/core/domain/CheckForGameIdAndTestModeChanges;", "getInitializationState", "Lcom/unity3d/ads/core/domain/GetInitializationState;", "setInitializationState", "Lcom/unity3d/ads/core/domain/SetInitializationState;", "validateGameId", "Lcom/unity3d/ads/core/domain/ValidateGameId;", "(Lcom/unity3d/ads/core/configuration/AlternativeFlowReader;Lcom/unity3d/ads/core/domain/CheckForGameIdAndTestModeChanges;Lcom/unity3d/ads/core/domain/GetInitializationState;Lcom/unity3d/ads/core/domain/SetInitializationState;Lcom/unity3d/ads/core/domain/ValidateGameId;)V", "getAlternativeFlowReader", "()Lcom/unity3d/ads/core/configuration/AlternativeFlowReader;", "getCheckForGameIdAndTestModeChanges", "()Lcom/unity3d/ads/core/domain/CheckForGameIdAndTestModeChanges;", "getGetInitializationState", "()Lcom/unity3d/ads/core/domain/GetInitializationState;", "getSetInitializationState", "()Lcom/unity3d/ads/core/domain/SetInitializationState;", "getValidateGameId", "()Lcom/unity3d/ads/core/domain/ValidateGameId;", "invoke", "", "gameId", "", "unity-ads_release"})
public final class CommonShouldAllowInitialization
implements ShouldAllowInitialization {
    @NotNull
    private final AlternativeFlowReader alternativeFlowReader;
    @NotNull
    private final CheckForGameIdAndTestModeChanges checkForGameIdAndTestModeChanges;
    @NotNull
    private final GetInitializationState getInitializationState;
    @NotNull
    private final SetInitializationState setInitializationState;
    @NotNull
    private final ValidateGameId validateGameId;

    public CommonShouldAllowInitialization(@NotNull AlternativeFlowReader alternativeFlowReader, @NotNull CheckForGameIdAndTestModeChanges checkForGameIdAndTestModeChanges, @NotNull GetInitializationState getInitializationState, @NotNull SetInitializationState setInitializationState, @NotNull ValidateGameId validateGameId) {
        Intrinsics.checkNotNullParameter((Object)alternativeFlowReader, (String)"alternativeFlowReader");
        Intrinsics.checkNotNullParameter((Object)checkForGameIdAndTestModeChanges, (String)"checkForGameIdAndTestModeChanges");
        Intrinsics.checkNotNullParameter((Object)getInitializationState, (String)"getInitializationState");
        Intrinsics.checkNotNullParameter((Object)setInitializationState, (String)"setInitializationState");
        Intrinsics.checkNotNullParameter((Object)validateGameId, (String)"validateGameId");
        this.alternativeFlowReader = alternativeFlowReader;
        this.checkForGameIdAndTestModeChanges = checkForGameIdAndTestModeChanges;
        this.getInitializationState = getInitializationState;
        this.setInitializationState = setInitializationState;
        this.validateGameId = validateGameId;
    }

    @NotNull
    public final AlternativeFlowReader getAlternativeFlowReader() {
        return this.alternativeFlowReader;
    }

    @NotNull
    public final CheckForGameIdAndTestModeChanges getCheckForGameIdAndTestModeChanges() {
        return this.checkForGameIdAndTestModeChanges;
    }

    @NotNull
    public final GetInitializationState getGetInitializationState() {
        return this.getInitializationState;
    }

    @NotNull
    public final SetInitializationState getSetInitializationState() {
        return this.setInitializationState;
    }

    @NotNull
    public final ValidateGameId getValidateGameId() {
        return this.validateGameId;
    }

    @Override
    public boolean invoke(@Nullable String gameId) {
        if (!this.validateGameId.invoke(gameId)) {
            return false;
        }
        if (this.alternativeFlowReader.invoke()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getInitializationState.invoke(false).ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    SdkProperties.notifyInitializationComplete();
                    return false;
                }
                case 3: 
                case 4: {
                    this.checkForGameIdAndTestModeChanges.invoke(false);
                    this.setInitializationState.invoke(InitializationState.INITIALIZING, false);
                    return true;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getInitializationState.invoke(true).ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                SdkProperties.notifyInitializationComplete();
                return false;
            }
            case 4: {
                SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to previous failed reason");
                return false;
            }
            case 3: {
                if (!EnvironmentCheck.isEnvironmentOk()) {
                    DeviceLog.error("Error during Unity Services environment check, halting Unity Services init");
                    SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to environment check failed");
                    InitializeEventsMetricSender.getInstance().sendMetric(InitMetric.newInitEnvironmentNotOk());
                    return false;
                }
                DeviceLog.info("Unity Services environment check OK");
                InitializeEventsMetricSender.getInstance().sendMetric(InitMetric.newInitEnvironmentOk());
                this.checkForGameIdAndTestModeChanges.invoke(true);
                this.setInitializationState.invoke(InitializationState.INITIALIZING, true);
                return true;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InitializationState.values().length];
            try {
                nArray[InitializationState.INITIALIZING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InitializationState.INITIALIZED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InitializationState.NOT_INITIALIZED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InitializationState.FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

