package com.unity3d.ads.adplayer

import android.content.Context
import android.net.Uri
import android.webkit.WebResourceResponse
import androidx.webkit.WebViewAssetLoader
import androidx.webkit.WebViewAssetLoader.Builder
import com.unity3d.ads.core.domain.GetLatestWebViewConfiguration
import com.unity3d.ads.core.extensions.guessMimeType
import com.unity3d.services.UnityAdsConstants.DefaultUrls.WEBVIEW_ASSET_PATH
import com.unity3d.services.UnityAdsConstants.DefaultUrls.WEBVIEW_ASSET_PATH_LOCAL
import com.unity3d.services.UnityAdsConstants.DefaultUrls.WEBVIEW_DOMAIN
import com.unity3d.services.core.log.DeviceLog
import kotlinx.coroutines.runBlocking

internal class CommonGetWebViewCacheAssetLoader(
    private val context: Context,
    private val getLatestWebViewConfiguration: GetLatestWebViewConfiguration
) : GetWebViewCacheAssetLoader {
    override fun invoke(): WebViewAssetLoader = runBlocking {
        val entryPointUri = Uri.parse(getLatestWebViewConfiguration().entryPoint)
        val currentPath = entryPointUri.path.let { path ->
            if (path.isNullOrEmpty()) {
                WEBVIEW_ASSET_PATH
            } else {
                path.substringBeforeLast('/') + '/'
            }
        }
        val currentDomain = entryPointUri.host.let {
            if (it.isNullOrEmpty()) {
                WEBVIEW_DOMAIN
            } else {
                it
            }
        }

        Builder()
            .addPathHandler(currentPath) { path: String ->
                try {
                    val inputStream = context.assets.open("$WEBVIEW_ASSET_PATH_LOCAL$path")
                    WebResourceResponse(path.guessMimeType(), null, inputStream)
                } catch (e: Exception) {
                    DeviceLog.debug("Webview Asset not found: %s", path)
                    null
                }
            }
            .setDomain(currentDomain)
            .build()
    }
}