package com.unity3d.ads.core.domain

import com.unity3d.ads.adplayer.*
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers




internal class CommonGetWebViewBridgeUseCase(
    private val dispatcher: CoroutineDispatcher = Dispatchers.Default,
) : GetWebViewBridgeUseCase {
    override fun invoke(webViewContainer: AndroidWebViewContainer, adPlayerScope: CoroutineScope): WebViewBridge {
        return CommonWebViewBridge(
            webViewContainer = webViewContainer,
            dispatcher = dispatcher,
            adPlayerScope = adPlayerScope,
        )
    }
}