package com.unity3d.ads.core.domain

import com.unity3d.ads.core.extensions.toBase64

internal class CommonGetHeaderBiddingToken(
    private val buildHeaderBiddingToken: BuildHeaderBiddingToken,
) : GetHeaderBiddingToken {
    override suspend fun invoke(): String {
        val rawToken = buildHeaderBiddingToken()
        // mediation receives a base64 encoded string
        val token = rawToken.toByteString().toBase64()
        // append version
        return "$HB_TOKEN_VERSION:$token"
    }

    companion object {
        const val HB_TOKEN_VERSION = "2"
    }
}