package com.unity3d.ads.core.data.datasource

import gatewayprotocol.v1.DynamicDeviceInfoOuterClass.DynamicDeviceInfo
import kotlinx.coroutines.flow.Flow

interface DynamicDeviceInfoDataSource {
    val volumeSettingsChange: Flow<VolumeSettingsChange>

    fun fetch(): DynamicDeviceInfo
    fun getRingerMode(): Int
    fun getOrientation(): String
    fun getCurrentUiTheme(): Int
    fun getLocaleList(): List<String>
    fun getConnectionTypeStr(): String
    fun hasInternet(): Boolean
}