/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.network.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b \u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH&R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/unity3d/services/core/network/core/UnityAdsUrlRequestCallback;", "Lorg/chromium/net/UrlRequest$Callback;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "bytesReceived", "Ljava/io/ByteArrayOutputStream;", "getFile", "()Ljava/io/File;", "receiveChannel", "Ljava/nio/channels/WritableByteChannel;", "kotlin.jvm.PlatformType", "sink", "Lokio/BufferedSink;", "onReadCompleted", "", "request", "Lorg/chromium/net/UrlRequest;", "info", "Lorg/chromium/net/UrlResponseInfo;", "byteBuffer", "Ljava/nio/ByteBuffer;", "onRedirectReceived", "newLocationUrl", "", "onResponseStarted", "onSucceeded", "bodyBytes", "", "Companion", "unity-ads_release"})
public abstract class UnityAdsUrlRequestCallback
extends UrlRequest.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File file;
    @NotNull
    private final ByteArrayOutputStream bytesReceived;
    private final WritableByteChannel receiveChannel;
    private BufferedSink sink;
    private static final int BYTE_BUFFER_CAPACITY_BYTES = 65536;

    public UnityAdsUrlRequestCallback(@Nullable File file) {
        this.file = file;
        this.bytesReceived = new ByteArrayOutputStream();
        this.receiveChannel = Channels.newChannel(this.bytesReceived);
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public void onRedirectReceived(@NotNull UrlRequest request2, @Nullable UrlResponseInfo info, @Nullable String newLocationUrl) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        request2.followRedirect();
    }

    public final void onResponseStarted(@NotNull UrlRequest request2, @NotNull UrlResponseInfo info) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        File file = this.file;
        boolean bl = file != null ? file.exists() : false;
        if (bl) {
            BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink((File)this.file));
            Intrinsics.checkNotNullExpressionValue((Object)bufferedSink, (String)"buffer(Okio.sink(file))");
            this.sink = bufferedSink;
        }
        request2.read(ByteBuffer.allocateDirect(65536));
    }

    public final void onReadCompleted(@NotNull UrlRequest request2, @NotNull UrlResponseInfo info, @NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        byteBuffer.flip();
        File file = this.file;
        boolean bl = file != null ? file.exists() : false;
        if (bl) {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sink");
                bufferedSink = null;
            }
            bufferedSink.write(byteBuffer);
        } else {
            this.receiveChannel.write(byteBuffer);
        }
        byteBuffer.clear();
        request2.read(byteBuffer);
    }

    public final void onSucceeded(@NotNull UrlRequest request2, @NotNull UrlResponseInfo info) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        byte[] bodyBytes = this.bytesReceived.toByteArray();
        if (this.file != null && this.file.exists()) {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sink");
                bufferedSink = null;
            }
            bufferedSink.close();
        }
        Intrinsics.checkNotNullExpressionValue((Object)bodyBytes, (String)"bodyBytes");
        this.onSucceeded(request2, info, bodyBytes);
    }

    public abstract void onSucceeded(@NotNull UrlRequest var1, @NotNull UrlResponseInfo var2, @NotNull byte[] var3);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/unity3d/services/core/network/core/UnityAdsUrlRequestCallback$Companion;", "", "()V", "BYTE_BUFFER_CAPACITY_BYTES", "", "unity-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

